/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTermRepository
extends EntityRepository<GlossaryTerm> {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryTermRepository.class);
    private static final String UPDATE_FIELDS = "tags,references,relatedTerms,reviewers,synonyms";
    private static final String PATCH_FIELDS = "tags,references,relatedTerms,reviewers,synonyms";

    public GlossaryTermRepository(CollectionDAO dao) {
        super("v1/glossaryTerms/", "glossaryTerm", GlossaryTerm.class, dao.glossaryTermDAO(), dao, "tags,references,relatedTerms,reviewers,synonyms", "tags,references,relatedTerms,reviewers,synonyms");
    }

    @Override
    public GlossaryTerm setFields(GlossaryTerm entity, EntityUtil.Fields fields) throws IOException {
        entity.setGlossary(this.getGlossary(entity));
        entity.setParent(this.getParent(entity));
        entity.setChildren(fields.contains("children") ? this.getChildren(entity) : null);
        entity.setRelatedTerms(fields.contains("relatedTerms") ? this.getRelatedTerms(entity) : null);
        entity.setReviewers(fields.contains("reviewers") ? this.getReviewers(entity) : null);
        entity.setUsageCount(fields.contains("usageCount") ? this.getUsageCount(entity) : null);
        return entity;
    }

    private Integer getUsageCount(GlossaryTerm term) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.GLOSSARY.ordinal(), term.getFullyQualifiedName());
    }

    private EntityReference getParent(GlossaryTerm entity) throws IOException {
        return this.getFromEntityRef(entity.getId(), Relationship.CONTAINS, "glossaryTerm", false);
    }

    private List<EntityReference> getChildren(GlossaryTerm entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findTo(entity.getId(), "glossaryTerm", Relationship.CONTAINS, "glossaryTerm");
        return EntityUtil.populateEntityReferences(ids, "glossaryTerm");
    }

    private List<EntityReference> getRelatedTerms(GlossaryTerm entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findBoth(entity.getId(), "glossaryTerm", Relationship.RELATED_TO, "glossaryTerm");
        return EntityUtil.populateEntityReferences(ids, "glossaryTerm");
    }

    private List<EntityReference> getReviewers(GlossaryTerm entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findFrom(entity.getId(), "glossaryTerm", Relationship.REVIEWS, "user");
        return EntityUtil.populateEntityReferences(ids, "user");
    }

    @Override
    public void prepare(GlossaryTerm entity) throws IOException {
        EntityReference parentTerm = Entity.getEntityReference(entity.getParent());
        entity.setParent(parentTerm);
        Glossary glossary = (Glossary)Entity.getEntity(entity.getGlossary(), "reviewers", Include.NON_DELETED);
        entity.setGlossary(glossary.getEntityReference());
        this.validateHierarchy(entity);
        entity.setReviewers(entity.getReviewers() == null ? glossary.getReviewers() : entity.getReviewers());
        EntityUtil.populateEntityReferences(entity.getRelatedTerms());
        EntityUtil.populateEntityReferences(entity.getReviewers());
    }

    @Override
    public void storeEntity(GlossaryTerm entity, boolean update) throws IOException {
        List tags = entity.getTags();
        EntityReference glossary = entity.getGlossary();
        EntityReference parentTerm = entity.getParent();
        List relatedTerms = entity.getRelatedTerms();
        List reviewers = entity.getReviewers();
        entity.withGlossary(null).withParent(null).withRelatedTerms(relatedTerms).withReviewers(null).withHref(null).withTags(null);
        this.store(entity, update);
        entity.withGlossary(glossary).withParent(parentTerm).withRelatedTerms(relatedTerms).withReviewers(reviewers).withTags(tags);
    }

    @Override
    public void storeRelationships(GlossaryTerm entity) {
        this.addGlossaryRelationship(entity);
        this.addParentRelationship(entity);
        for (EntityReference relTerm : CommonUtil.listOrEmpty((List)entity.getRelatedTerms())) {
            this.addRelationship(entity.getId(), relTerm.getId(), "glossaryTerm", "glossaryTerm", Relationship.RELATED_TO, true);
        }
        for (EntityReference reviewer : CommonUtil.listOrEmpty((List)entity.getReviewers())) {
            this.addRelationship(reviewer.getId(), entity.getId(), "user", "glossaryTerm", Relationship.REVIEWS);
        }
        this.applyTags(entity);
    }

    @Override
    public void restorePatchAttributes(GlossaryTerm original, GlossaryTerm updated) {
        updated.withChildren(original.getChildren());
    }

    @Override
    public void setFullyQualifiedName(GlossaryTerm entity) {
        if (entity.getParent() == null) {
            entity.setFullyQualifiedName(FullyQualifiedName.add(entity.getGlossary().getName(), entity.getName()));
        } else {
            EntityReference parent = entity.getParent();
            entity.setFullyQualifiedName(FullyQualifiedName.add(parent.getFullyQualifiedName(), entity.getName()));
        }
    }

    protected EntityReference getGlossary(GlossaryTerm term) throws IOException {
        return this.getFromEntityRef(term.getId(), Relationship.CONTAINS, "glossary", true);
    }

    public EntityReference getGlossary(String id) throws IOException {
        return this.daoCollection.glossaryDAO().findEntityReferenceById(UUID.fromString(id), Include.ALL);
    }

    public GlossaryTermUpdater getUpdater(GlossaryTerm original, GlossaryTerm updated, EntityRepository.Operation operation) {
        return new GlossaryTermUpdater(original, updated, operation);
    }

    @Override
    protected void postDelete(GlossaryTerm entity) {
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.GLOSSARY.ordinal(), entity.getFullyQualifiedName());
    }

    private void addGlossaryRelationship(GlossaryTerm term) {
        this.addRelationship(term.getGlossary().getId(), term.getId(), "glossary", "glossaryTerm", Relationship.CONTAINS);
    }

    private void deleteGlossaryRelationship(GlossaryTerm term) {
        this.deleteRelationship(term.getGlossary().getId(), "glossary", term.getId(), "glossaryTerm", Relationship.CONTAINS);
    }

    private void updateGlossaryRelationship(GlossaryTerm orig, GlossaryTerm updated) {
        this.deleteGlossaryRelationship(orig);
        this.addGlossaryRelationship(updated);
    }

    private void addParentRelationship(GlossaryTerm term) {
        if (term.getParent() != null) {
            this.addRelationship(term.getParent().getId(), term.getId(), "glossaryTerm", "glossaryTerm", Relationship.CONTAINS);
        }
    }

    private void deleteParentRelationship(GlossaryTerm term) {
        if (term.getParent() != null) {
            this.deleteRelationship(term.getParent().getId(), "glossaryTerm", term.getId(), "glossaryTerm", Relationship.CONTAINS);
        }
    }

    private void updateParentRelationship(GlossaryTerm orig, GlossaryTerm updated) {
        this.deleteParentRelationship(orig);
        this.addParentRelationship(updated);
    }

    private void validateHierarchy(GlossaryTerm term) {
        if (term.getParent() == null) {
            return;
        }
        if (!term.getParent().getFullyQualifiedName().startsWith(term.getGlossary().getFullyQualifiedName())) {
            throw new IllegalArgumentException(String.format("Invalid hierarchy - parent [%s] does not belong to glossary[%s]", term.getParent().getFullyQualifiedName(), term.getGlossary().getFullyQualifiedName()));
        }
    }

    public class GlossaryTermUpdater
    extends EntityRepository.EntityUpdater {
        public GlossaryTermUpdater(GlossaryTerm original, GlossaryTerm updated, EntityRepository.Operation operation) {
            super((EntityRepository)GlossaryTermRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateStatus((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateSynonyms((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateReferences((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateRelatedTerms((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateReviewers((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateName((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateParent((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
        }

        @Override
        protected void updateTags(String fqn, String fieldName, List<TagLabel> origTags, List<TagLabel> updatedTags) throws IOException {
            super.updateTags(fqn, fieldName, origTags, updatedTags);
            List<String> targetFQNList = GlossaryTermRepository.this.daoCollection.tagUsageDAO().tagTargetFQN(fqn);
            for (String targetFQN : targetFQNList) {
                GlossaryTermRepository.this.applyTags(updatedTags, targetFQN);
            }
        }

        private void updateStatus(GlossaryTerm origTerm, GlossaryTerm updatedTerm) throws JsonProcessingException {
            this.recordChange("status", origTerm.getStatus(), updatedTerm.getStatus());
        }

        private void updateSynonyms(GlossaryTerm origTerm, GlossaryTerm updatedTerm) throws JsonProcessingException {
            List origSynonyms = CommonUtil.listOrEmpty((List)origTerm.getSynonyms());
            List updatedSynonyms = CommonUtil.listOrEmpty((List)updatedTerm.getSynonyms());
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("synonyms", origSynonyms, updatedSynonyms, added, deleted, EntityUtil.stringMatch);
        }

        private void updateReferences(GlossaryTerm origTerm, GlossaryTerm updatedTerm) throws JsonProcessingException {
            List origReferences = CommonUtil.listOrEmpty((List)origTerm.getReferences());
            List updatedReferences = CommonUtil.listOrEmpty((List)updatedTerm.getReferences());
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("references", origReferences, updatedReferences, added, deleted, EntityUtil.termReferenceMatch);
        }

        private void updateRelatedTerms(GlossaryTerm origTerm, GlossaryTerm updatedTerm) throws JsonProcessingException {
            List origRelated = CommonUtil.listOrEmpty((List)origTerm.getRelatedTerms());
            List updatedRelated = CommonUtil.listOrEmpty((List)updatedTerm.getRelatedTerms());
            this.updateToRelationships("relatedTerms", "glossaryTerm", origTerm.getId(), Relationship.RELATED_TO, "glossaryTerm", origRelated, updatedRelated, true);
        }

        private void updateReviewers(GlossaryTerm origTerm, GlossaryTerm updatedTerm) throws JsonProcessingException {
            List origReviewers = CommonUtil.listOrEmpty((List)origTerm.getReviewers());
            List updatedReviewers = CommonUtil.listOrEmpty((List)updatedTerm.getReviewers());
            this.updateFromRelationships("reviewers", "user", origReviewers, updatedReviewers, Relationship.REVIEWS, "glossaryTerm", origTerm.getId());
        }

        public void updateName(GlossaryTerm original, GlossaryTerm updated) throws IOException {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), GlossaryTermRepository.this.entityType));
                }
                LOG.info("Glossary term name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                GlossaryTermRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                GlossaryTermRepository.this.daoCollection.tagUsageDAO().rename(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                this.recordChange("name", original.getName(), updated.getName());
            }
        }

        private void updateParent(GlossaryTerm original, GlossaryTerm updated) throws JsonProcessingException {
            UUID newParentId;
            UUID oldParentId = EntityUtil.getId(original.getParent());
            boolean parentChanged = !Objects.equals(oldParentId, newParentId = EntityUtil.getId(updated.getParent()));
            UUID oldGlossaryId = EntityUtil.getId(original.getGlossary());
            UUID newGlossaryId = EntityUtil.getId(updated.getGlossary());
            boolean glossaryChanged = !Objects.equals(oldGlossaryId, newGlossaryId);
            GlossaryTermRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            GlossaryTermRepository.this.daoCollection.tagUsageDAO().rename(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            if (glossaryChanged) {
                GlossaryTermRepository.this.updateGlossaryRelationship(original, updated);
                this.recordChange("glossary", original.getGlossary(), updated.getGlossary(), true, EntityUtil.entityReferenceMatch);
            }
            if (parentChanged) {
                GlossaryTermRepository.this.updateParentRelationship(original, updated);
                this.recordChange("parent", original.getParent(), updated.getParent(), true, EntityUtil.entityReferenceMatch);
            }
        }
    }
}

