/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.type.Include;

public class ListFilter {
    private final Include include;
    private final Map<String, String> queryParams = new HashMap<String, String>();

    public ListFilter() {
        this(Include.NON_DELETED);
    }

    public ListFilter(Include include) {
        this.include = include;
    }

    public ListFilter addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public String getQueryParam(String name) {
        if (name.equals("include")) {
            return this.include.value();
        }
        return this.queryParams.get(name);
    }

    public Include getInclude() {
        return this.include;
    }

    public String getCondition() {
        return this.getCondition(null);
    }

    public String getCondition(String tableName) {
        String condition = this.getIncludeCondition(tableName);
        condition = this.addCondition(condition, this.getDatabaseCondition(tableName));
        condition = this.addCondition(condition, this.getServiceCondition(tableName));
        condition = this.addCondition(condition, this.getParentCondition(tableName));
        condition = this.addCondition(condition, this.getCategoryCondition(tableName));
        condition = this.addCondition(condition, this.getWebhookCondition(tableName));
        return (condition = this.addCondition(condition, this.getWebhookTypeCondition(tableName))).isEmpty() ? "WHERE TRUE" : "WHERE " + condition;
    }

    public String getIncludeCondition(String tableName) {
        Object columnName;
        Object object = columnName = tableName == null ? "deleted" : tableName + ".deleted";
        if (this.include == Include.NON_DELETED) {
            return (String)columnName + " = FALSE";
        }
        if (this.include == Include.DELETED) {
            return (String)columnName + " = TRUE";
        }
        return "";
    }

    public String getDatabaseCondition(String tableName) {
        String database = this.queryParams.get("database");
        return database == null ? "" : this.getFqnPrefixCondition(tableName, this.escape(database));
    }

    public String getServiceCondition(String tableName) {
        String service = this.queryParams.get("service");
        return service == null ? "" : this.getFqnPrefixCondition(tableName, this.escape(service));
    }

    public String getParentCondition(String tableName) {
        String parentFqn = this.queryParams.get("parent");
        return parentFqn == null ? "" : this.getFqnPrefixCondition(tableName, this.escape(parentFqn));
    }

    public String getCategoryCondition(String tableName) {
        String category = this.queryParams.get("category");
        return category == null ? "" : this.getCategoryPrefixCondition(tableName, this.escape(category));
    }

    public String getWebhookCondition(String tableName) {
        String webhookStatus = this.queryParams.get("status");
        return webhookStatus == null ? "" : this.getStatusPrefixCondition(tableName, this.escape(webhookStatus));
    }

    public String getWebhookTypeCondition(String tableName) {
        String webhookType = this.queryParams.get("webhookType");
        return webhookType == null ? "" : this.getWebhookTypePrefixCondition(tableName, this.escape(webhookType));
    }

    private String getFqnPrefixCondition(String tableName, String fqnPrefix) {
        if (fqnPrefix.contains("_") || fqnPrefix.contains("-")) {
            fqnPrefix = this.format(fqnPrefix);
        }
        return tableName == null ? String.format("fullyQualifiedName LIKE '%s%s%%'", fqnPrefix, ".") : String.format("%s.fullyQualifiedName LIKE '%s%s%%'", tableName, fqnPrefix, ".");
    }

    private String getWebhookTypePrefixCondition(String tableName, String typePrefix) {
        return tableName == null ? String.format("webhookType LIKE '%s%%'", typePrefix) : String.format("%s.webhookType LIKE '%s%%'", tableName, typePrefix);
    }

    private String getCategoryPrefixCondition(String tableName, String category) {
        return tableName == null ? String.format("category LIKE '%s%s%%'", category, "") : String.format("%s.category LIKE '%s%s%%'", tableName, category, "");
    }

    private String getStatusPrefixCondition(String tableName, String statusPrefix) {
        if (!statusPrefix.isEmpty()) {
            ArrayList<String> statusList = new ArrayList<String>(Arrays.asList(statusPrefix.split(",")));
            ArrayList<CallSite> condition = new ArrayList<CallSite>();
            for (String s : statusList) {
                String format = "\"" + s + "\"";
                condition.add((CallSite)((Object)format));
            }
            return "status in (" + String.join((CharSequence)",", condition) + ")";
        }
        return tableName == null ? String.format("status LIKE '%s%s%%'", statusPrefix, "") : String.format("%s.status LIKE '%s%s%%'", tableName, statusPrefix, "");
    }

    private String addCondition(String condition1, String condition2) {
        if (condition1.isEmpty()) {
            return condition2;
        }
        if (condition2.isEmpty()) {
            return condition1;
        }
        return condition1 + " AND " + condition2;
    }

    private String escape(String name) {
        return name.replace("'", "''");
    }

    private String format(String name) {
        return name.contains("-") ? name.replaceAll("-", "\\\\-") : name.replaceAll("_", "\\\\_");
    }
}

