/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleRepository
extends EntityRepository<Role> {
    private static final Logger LOG = LoggerFactory.getLogger(RoleRepository.class);

    public RoleRepository(CollectionDAO dao) {
        super("/v1/roles/", "role", Role.class, dao.roleDAO(), dao, "policies", "policies");
    }

    @Override
    public Role setFields(Role role, EntityUtil.Fields fields) throws IOException {
        role.setPolicies(fields.contains("policies") ? this.getPolicies(role) : null);
        role.setTeams(fields.contains("teams") ? this.getTeams(role) : null);
        role.setUsers(fields.contains("users") ? this.getUsers(role) : null);
        return role;
    }

    private List<EntityReference> getPolicies(@NonNull Role role) throws IOException {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        List<CollectionDAO.EntityRelationshipRecord> result = this.findTo(role.getId(), "role", Relationship.HAS, "policy");
        return EntityUtil.populateEntityReferences(result, "policy");
    }

    private List<EntityReference> getUsers(@NonNull Role role) throws IOException {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(role.getId(), "role", Relationship.HAS, "user");
        return EntityUtil.populateEntityReferences(records, "user");
    }

    private List<EntityReference> getTeams(@NonNull Role role) throws IOException {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(role.getId(), "role", Relationship.HAS, "team");
        return EntityUtil.populateEntityReferences(records, "team");
    }

    @Override
    public void restorePatchAttributes(Role original, Role updated) {
        updated.withName(original.getName()).withId(original.getId());
    }

    @Override
    public void prepare(Role role) throws IOException {
        if (CommonUtil.listOrEmpty((List)role.getPolicies()).isEmpty()) {
            throw new IllegalArgumentException("At least one policy is required in a role");
        }
        EntityUtil.populateEntityReferences(role.getPolicies());
    }

    @Override
    @Transaction
    public void storeEntity(Role role, boolean update) throws IOException {
        List policies = role.getPolicies();
        role.withPolicies(null).withHref(null);
        this.store(role, update);
        role.withPolicies(policies);
    }

    @Override
    public void storeRelationships(Role role) {
        for (EntityReference policy : CommonUtil.listOrEmpty((List)role.getPolicies())) {
            this.addRelationship(role.getId(), policy.getId(), "role", "policy", Relationship.HAS);
        }
    }

    public RoleUpdater getUpdater(Role original, Role updated, EntityRepository.Operation operation) {
        return new RoleUpdater(original, updated, operation);
    }

    @Override
    protected void preDelete(Role entity) {
        if (Boolean.FALSE.equals(entity.getAllowDelete())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityDeleteNotAllowed(entity.getName(), "role"));
        }
    }

    public class RoleUpdater
    extends EntityRepository.EntityUpdater {
        public RoleUpdater(Role original, Role updated, EntityRepository.Operation operation) {
            super((EntityRepository)RoleRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updatePolicies(CommonUtil.listOrEmpty((List)((Role)this.original).getPolicies()), CommonUtil.listOrEmpty((List)((Role)this.updated).getPolicies()));
        }

        private void updatePolicies(List<EntityReference> origPolicies, List<EntityReference> updatedPolicies) throws JsonProcessingException {
            ArrayList addedPolicies = new ArrayList();
            ArrayList deletedPolicies = new ArrayList();
            boolean changed = this.recordListChange("policies", origPolicies, updatedPolicies, addedPolicies, deletedPolicies, EntityUtil.entityReferenceMatch);
            if (changed) {
                RoleRepository.this.deleteFrom(((Role)this.original).getId(), "role", Relationship.HAS, "policy");
                RoleRepository.this.storeRelationships((Role)this.updated);
            }
        }
    }
}

