/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;

public class StorageServiceRepository
extends EntityRepository<StorageService> {
    private static final String UPDATE_FIELDS = "owner";

    public StorageServiceRepository(CollectionDAO dao) {
        super("v1/services/storageServices/", "storageService", StorageService.class, dao.storageServiceDAO(), dao, "", UPDATE_FIELDS);
    }

    @Override
    public StorageService setFields(StorageService entity, EntityUtil.Fields fields) throws IOException {
        entity.setOwner(fields.contains(UPDATE_FIELDS) ? this.getOwner(entity) : null);
        return entity;
    }

    @Override
    public void prepare(StorageService entity) {
    }

    @Override
    public void storeEntity(StorageService service, boolean update) throws IOException {
        EntityReference owner = service.getOwner();
        service.withOwner(null).withHref(null);
        this.store(service, update);
        service.withOwner(owner);
    }

    @Override
    public void storeRelationships(StorageService entity) {
        this.storeOwner(entity, entity.getOwner());
    }
}

