/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagCategory;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TagRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagCategoryRepository
extends EntityRepository<TagCategory> {
    private static final Logger LOG = LoggerFactory.getLogger(TagCategoryRepository.class);
    private final TagRepository tagRepository;

    public TagCategoryRepository(CollectionDAO dao, TagRepository tagRepository) {
        super("/v1/tags/", "tagCategory", TagCategory.class, dao.tagCategoryDAO(), dao, "", "");
        this.tagRepository = tagRepository;
    }

    @Transaction
    public void initCategory(TagCategory category) throws IOException {
        String json = this.dao.findJsonByFqn(category.getName(), Include.ALL);
        if (json == null) {
            LOG.info("Tag category {} is not initialized", (Object)category.getName());
            this.storeEntity(category, false);
            for (Tag primaryTag : category.getChildren()) {
                primaryTag.setFullyQualifiedName(FullyQualifiedName.build(category.getName(), primaryTag.getName()));
                this.tagRepository.storeEntity(primaryTag, false);
            }
        } else {
            LOG.info("Tag category {} is already initialized", (Object)category.getName());
        }
    }

    private void populateCategoryTags(TagCategory category, EntityUtil.Fields fields) throws IOException {
        ListFilter listFilter = new ListFilter(Include.ALL).addQueryParam("parent", category.getName());
        List<String> groupJsons = this.daoCollection.tagDAO().listAfter(listFilter, 10000, "");
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (String json : groupJsons) {
            Tag tag = this.tagRepository.setFieldsInternal(JsonUtils.readValue(json, Tag.class), fields);
            tagList.add(this.tagRepository.populateChildrenTags(tag, fields));
        }
        category.withChildren(tagList.isEmpty() ? null : tagList);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TagCategory original, TagCategory updated, EntityRepository.Operation operation) {
        return new TagCategoryUpdater(original, updated, operation);
    }

    @Override
    public TagCategory setFields(TagCategory category, EntityUtil.Fields fields) throws IOException {
        this.populateCategoryTags(category, fields);
        return category.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(category) : null);
    }

    @Override
    public void prepare(TagCategory entity) {
    }

    @Override
    public void storeEntity(TagCategory category, boolean update) throws IOException {
        List primaryTags = category.getChildren();
        category.setChildren(null);
        this.store(category, update);
        category.withChildren(primaryTags);
    }

    @Override
    public void storeRelationships(TagCategory entity) {
    }

    private Integer getUsageCount(TagCategory category) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.TAG.ordinal(), category.getName());
    }

    @Transaction
    public TagCategory delete(UriInfo uriInfo, UUID id) throws IOException {
        TagCategory category = (TagCategory)this.get(uriInfo, id, EntityUtil.Fields.EMPTY_FIELDS, Include.NON_DELETED);
        this.checkSystemEntityDeletion(category);
        this.dao.delete(id.toString());
        this.daoCollection.tagDAO().deleteTagsByPrefix(category.getName());
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.TAG.ordinal(), category.getName());
        this.daoCollection.tagUsageDAO().deleteTagLabelsByPrefix(TagLabel.TagSource.TAG.ordinal(), category.getName());
        return category;
    }

    public class TagCategoryUpdater
    extends EntityRepository.EntityUpdater {
        public TagCategoryUpdater(TagCategory original, TagCategory updated, EntityRepository.Operation operation) {
            super((EntityRepository)TagCategoryRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("mutuallyExclusive", ((TagCategory)this.original).getMutuallyExclusive(), ((TagCategory)this.updated).getMutuallyExclusive());
            this.updateName((TagCategory)this.original, (TagCategory)this.updated);
        }

        public void updateName(TagCategory original, TagCategory updated) throws IOException {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), TagCategoryRepository.this.entityType));
                }
                LOG.info("Tag category name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                TagCategoryRepository.this.daoCollection.tagDAO().updateFqn(original.getName(), updated.getName());
                TagCategoryRepository.this.daoCollection.tagUsageDAO().updateTagPrefix(original.getName(), updated.getName());
                this.recordChange("name", original.getName(), updated.getName());
            }
            TagCategoryRepository.this.populateCategoryTags(updated, EntityUtil.Fields.EMPTY_FIELDS);
        }
    }

    public static class TagLabelMapper
    implements RowMapper<TagLabel> {
        public TagLabel map(ResultSet r, StatementContext ctx) throws SQLException {
            return new TagLabel().withLabelType(TagLabel.LabelType.values()[r.getInt("labelType")]).withState(TagLabel.State.values()[r.getInt("state")]).withTagFQN(r.getString("tagFQN"));
        }
    }
}

