/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagRepository
extends EntityRepository<Tag> {
    private static final Logger LOG = LoggerFactory.getLogger(TagRepository.class);

    public TagRepository(CollectionDAO dao) {
        super("/v1/tags/", "tag", Tag.class, dao.tagDAO(), dao, "", "");
    }

    Tag populateChildrenTags(Tag tag, EntityUtil.Fields fields) throws IOException {
        ListFilter listFilter = new ListFilter(Include.ALL).addQueryParam("parent", tag.getFullyQualifiedName());
        List<String> tagJsons = this.dao.listAfter(listFilter, 10000, null);
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (String json : CommonUtil.listOrEmpty(tagJsons)) {
            Tag childTag = this.setFieldsInternal(JsonUtils.readValue(json, Tag.class), fields);
            tagList.add(this.populateChildrenTags(childTag, fields));
        }
        return tag.withChildren(!tagList.isEmpty() ? tagList : null);
    }

    @Override
    public void prepare(Tag entity) {
        String[] split = FullyQualifiedName.split(entity.getFullyQualifiedName());
        String categoryName = split[0];
        this.daoCollection.tagCategoryDAO().findEntityByName(categoryName);
        if (split.length == 3) {
            this.dao.findEntityByName(FullyQualifiedName.build(split[0], split[1]));
        }
    }

    @Override
    public void storeEntity(Tag tag, boolean update) throws IOException {
        List tags = tag.getChildren();
        tag.setChildren(null);
        this.store(tag, update);
        tag.setChildren(tags);
        LOG.info("Added tag {}", (Object)tag.getFullyQualifiedName());
        for (Tag children : CommonUtil.listOrEmpty((List)tag.getChildren())) {
            children.setChildren(null);
            children.setFullyQualifiedName(FullyQualifiedName.add(children.getFullyQualifiedName(), children.getName()));
            LOG.info("Added tag {}", (Object)children.getFullyQualifiedName());
            this.dao.insert((EntityInterface)children);
        }
    }

    @Override
    public void storeRelationships(Tag entity) {
    }

    @Override
    public void setFullyQualifiedName(Tag entity) {
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Tag original, Tag updated, EntityRepository.Operation operation) {
        return new TagUpdater(original, updated, operation);
    }

    @Override
    protected void postDelete(Tag entity) {
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.TAG.ordinal(), entity.getFullyQualifiedName());
    }

    @Override
    public Tag setFields(Tag tag, EntityUtil.Fields fields) throws IOException {
        this.populateChildrenTags(tag, fields);
        return tag.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(tag) : null);
    }

    private Integer getUsageCount(Tag tag) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.TAG.ordinal(), tag.getFullyQualifiedName());
    }

    @Transaction
    public Tag delete(UriInfo uriInfo, UUID id) throws IOException {
        Tag tag = (Tag)this.get(uriInfo, id, EntityUtil.Fields.EMPTY_FIELDS, Include.NON_DELETED);
        this.checkSystemEntityDeletion(tag);
        this.dao.delete(id.toString());
        this.daoCollection.tagDAO().deleteTagsByPrefix(tag.getFullyQualifiedName());
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.TAG.ordinal(), tag.getFullyQualifiedName());
        this.daoCollection.tagUsageDAO().deleteTagLabelsByPrefix(TagLabel.TagSource.TAG.ordinal(), tag.getFullyQualifiedName());
        return tag;
    }

    public class TagUpdater
    extends EntityRepository.EntityUpdater {
        public TagUpdater(Tag original, Tag updated, EntityRepository.Operation operation) {
            super((EntityRepository)TagRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("mutuallyExclusive", ((Tag)this.original).getMutuallyExclusive(), ((Tag)this.updated).getMutuallyExclusive());
            this.updateName((Tag)this.original, (Tag)this.updated);
        }

        public void updateName(Tag original, Tag updated) throws IOException {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), TagRepository.this.entityType));
                }
                LOG.info("Tag name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                TagRepository.this.daoCollection.tagDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                TagRepository.this.daoCollection.tagUsageDAO().rename(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                this.recordChange("name", original.getName(), updated.getName());
            }
            TagRepository.this.populateChildrenTags(updated, EntityUtil.Fields.EMPTY_FIELDS);
        }
    }
}

