/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.List;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;

public class TestSuiteRepository
extends EntityRepository<TestSuite> {
    private static final String UPDATE_FIELDS = "owner,tests";
    private static final String PATCH_FIELDS = "owner,tests";

    public TestSuiteRepository(CollectionDAO dao) {
        super("/v1/testSuite", "testSuite", TestSuite.class, dao.testSuiteDAO(), dao, "owner,tests", "owner,tests");
    }

    @Override
    public TestSuite setFields(TestSuite entity, EntityUtil.Fields fields) throws IOException {
        entity.setOwner(fields.contains("owner") ? this.getOwner(entity) : null);
        entity.setPipeline(fields.contains("pipelines") ? this.getIngestionPipeline(entity) : null);
        entity.setTests(fields.contains("tests") ? this.getTestCases(entity) : null);
        return entity;
    }

    @Override
    public void prepare(TestSuite entity) {
    }

    private List<EntityReference> getTestCases(TestSuite entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> testCases = this.findTo(entity.getId(), "testSuite", Relationship.CONTAINS, "testCase");
        return EntityUtil.getEntityReferences(testCases);
    }

    @Override
    public void storeEntity(TestSuite entity, boolean update) throws IOException {
        EntityReference owner = entity.getOwner();
        entity.withOwner(null).withHref(null);
        this.store(entity, update);
        entity.withOwner(owner);
    }

    @Override
    public void storeRelationships(TestSuite entity) {
        this.storeOwner(entity, entity.getOwner());
    }

    private EntityReference getIngestionPipeline(TestSuite testSuite) throws IOException {
        return this.getToEntityRef(testSuite.getId(), Relationship.CONTAINS, "ingestionPipeline", false);
    }

    public class TestSuiteUpdater
    extends EntityRepository.EntityUpdater {
        public TestSuiteUpdater(TestSuite original, TestSuite updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestSuiteRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("tests", ((TestSuite)this.original).getTests(), ((TestSuite)this.updated).getTests());
        }
    }
}

