/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.tuple.Triple;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.type.Category;
import org.openmetadata.schema.entity.type.CustomProperty;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.TypeRegistry;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRepository
extends EntityRepository<Type> {
    private static final Logger LOG = LoggerFactory.getLogger(TypeRepository.class);
    private static final String UPDATE_FIELDS = "customProperties";
    private static final String PATCH_FIELDS = "customProperties";

    public TypeRepository(CollectionDAO dao) {
        super("v1/metadata/types/", "type", Type.class, dao.typeEntityDAO(), dao, "customProperties", "customProperties");
    }

    @Override
    public Type setFields(Type type, EntityUtil.Fields fields) throws IOException {
        type.withCustomProperties(fields.contains("customProperties") ? this.getCustomProperties(type) : null);
        return type;
    }

    @Override
    public void prepare(Type type) {
        TypeRegistry.instance().validateCustomProperties(type);
    }

    @Override
    public void storeEntity(Type type, boolean update) throws IOException {
        URI href = type.getHref();
        List customProperties = type.getCustomProperties();
        type.withHref(null).withCustomProperties(null);
        this.store(type, update);
        type.withHref(href).withCustomProperties(customProperties);
        this.updateTypeMap(type);
    }

    public void addToRegistry(Type type) {
        this.updateTypeMap(type);
    }

    @Override
    public void storeRelationships(Type type) {
    }

    private void updateTypeMap(Type entity) {
        TypeRegistry.instance().addType(entity);
    }

    @Override
    protected void postDelete(Type entity) {
        TypeRegistry.instance().removeType(entity.getName());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Type original, Type updated, EntityRepository.Operation operation) {
        return new TypeUpdater(original, updated, operation);
    }

    public RestUtil.PutResponse<Type> addCustomProperty(UriInfo uriInfo, String updatedBy, UUID id, CustomProperty property) throws IOException {
        Type type = (Type)this.dao.findEntityById(id, Include.NON_DELETED);
        property.setPropertyType(this.dao.findEntityReferenceById(property.getPropertyType().getId(), Include.NON_DELETED));
        if (type.getCategory().equals((Object)Category.Field)) {
            throw new IllegalArgumentException("Only entity types can be extended and field types can't be extended");
        }
        this.setFieldsInternal(type, this.putFields);
        this.dao.findEntityById(property.getPropertyType().getId());
        ArrayList<CustomProperty> updatedProperties = new ArrayList<CustomProperty>(List.of(property));
        for (CustomProperty existing : type.getCustomProperties()) {
            if (existing.getName().equals(property.getName())) continue;
            updatedProperties.add(existing);
        }
        type.setCustomProperties(updatedProperties);
        type.setUpdatedBy(updatedBy);
        type.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        return this.createOrUpdate(uriInfo, type);
    }

    private List<CustomProperty> getCustomProperties(Type type) throws IOException {
        if (type.getCategory().equals((Object)Category.Field)) {
            return null;
        }
        ArrayList<CustomProperty> customProperties = new ArrayList<CustomProperty>();
        List<Triple<String, String, String>> results = this.daoCollection.fieldRelationshipDAO().listToByPrefix(this.getCustomPropertyFQNPrefix(type.getName()), "type", "type", Relationship.HAS.ordinal());
        for (Triple<String, String, String> result : results) {
            CustomProperty property = JsonUtils.readValue((String)result.getRight(), CustomProperty.class);
            property.setPropertyType(this.dao.findEntityReferenceByName((String)result.getMiddle()));
            customProperties.add(property);
        }
        customProperties.sort(EntityUtil.compareCustomProperty);
        return customProperties;
    }

    public class TypeUpdater
    extends EntityRepository.EntityUpdater {
        public TypeUpdater(Type original, Type updated, EntityRepository.Operation operation) {
            super((EntityRepository)TypeRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateCustomProperties();
        }

        private void updateCustomProperties() throws JsonProcessingException {
            String customPropertyFQN;
            List updatedFields = CommonUtil.listOrEmpty((List)((Type)this.updated).getCustomProperties());
            List origFields = CommonUtil.listOrEmpty((List)((Type)this.original).getCustomProperties());
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("customProperties", origFields, updatedFields, added, deleted, EntityUtil.customFieldMatch);
            for (CustomProperty property : added) {
                customPropertyFQN = TypeRepository.this.getCustomPropertyFQN(((Type)this.updated).getName(), property.getName());
                String customPropertyJson = JsonUtils.pojoToJson(property);
                LOG.info("Adding customProperty {} with type {} to the entity {}", new Object[]{customPropertyFQN, property.getPropertyType().getName(), ((Type)this.updated).getName()});
                TypeRepository.this.daoCollection.fieldRelationshipDAO().insert(customPropertyFQN, property.getPropertyType().getName(), "type", "type", Relationship.HAS.ordinal(), customPropertyJson);
            }
            for (CustomProperty property : deleted) {
                customPropertyFQN = TypeRepository.this.getCustomPropertyFQN(((Type)this.updated).getName(), property.getName());
                LOG.info("Deleting customProperty {} with type {} from the entity {}", new Object[]{property.getName(), property.getPropertyType().getName(), ((Type)this.updated).getName()});
                TypeRepository.this.daoCollection.fieldRelationshipDAO().delete(customPropertyFQN, property.getPropertyType().getName(), "type", "type", Relationship.HAS.ordinal());
                TypeRepository.this.daoCollection.entityExtensionDAO().deleteExtension(customPropertyFQN);
            }
            for (CustomProperty updated : updatedFields) {
                CustomProperty stored = origFields.stream().filter(c -> EntityUtil.customFieldMatch.test((CustomProperty)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateCustomPropertyDescription(stored, updated);
            }
        }

        private void updateCustomPropertyDescription(CustomProperty orig, CustomProperty updated) throws JsonProcessingException {
            String fieldName = EntityUtil.getCustomField(orig, "description");
            this.recordChange(fieldName, orig.getDescription(), updated.getDescription());
        }
    }
}

