/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.analytics;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ReportDataRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/analytic/reportData")
@Api(value="ReportData collection", tags={"ReportData collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="reportData")
public class ReportDataResource {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDataResource.class);
    public static final String COLLECTION_PATH = "v1/analytic/reportData";
    protected final ReportDataRepository dao;
    protected final Authorizer authorizer;

    @Inject
    public ReportDataResource(CollectionDAO dao, Authorizer authorizer) {
        this.authorizer = authorizer;
        this.dao = new ReportDataRepository(dao);
    }

    @GET
    @Operation(operationId="getReportData", summary="List the report data", tags={"reportData"}, description="Get a list of all the report data for a given reportDataType, optionally filtered by  `startTs` and `endTs` of the result. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of report data", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportDataResultList.class))})})
    public ResultList<ReportData> list(@Context SecurityContext securityContext, @Parameter(description="report data type", schema=@Schema(implementation=ReportData.ReportDataType.class)) @QueryParam(value="reportDataType") @NonNull ReportData.ReportDataType reportDataType, @Parameter(description="Filter reportData results after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") @NonNull Long startTs, @Parameter(description="Filter reportData results before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") @NonNull Long endTs) throws IOException {
        if (reportDataType == null) {
            throw new NullPointerException("reportDataType is marked non-null but is null");
        }
        if (startTs == null) {
            throw new NullPointerException("startTs is marked non-null but is null");
        }
        if (endTs == null) {
            throw new NullPointerException("endTs is marked non-null but is null");
        }
        return this.dao.getReportData(reportDataType, startTs, endTs);
    }

    @POST
    @Operation(operationId="addReportData", summary="Add report data", tags={"reportData"}, description="Add report data", responses={@ApiResponse(responseCode="200", description="Successfully added reportData.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportData.class))})})
    public Response addReportData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid ReportData reportData) throws IOException {
        return this.dao.addReportData(reportData);
    }

    public ReportDataRepository getDao() {
        return this.dao;
    }

    public static class ReportDataResultList
    extends ResultList<ReportData> {
    }
}

