/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.dqtests;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.tests.CreateTestSuite;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/testSuite")
@Api(value="Test Suite collection", tags={"Test Suite collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="TestSuites")
public class TestSuiteResource
extends EntityResource<TestSuite, TestSuiteRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteResource.class);
    public static final String COLLECTION_PATH = "/v1/testSuite";
    static final String FIELDS = "owner,tests";

    @Override
    public TestSuite addHref(UriInfo uriInfo, TestSuite testSuite) {
        testSuite.withHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, testSuite.getId()));
        Entity.withHref(uriInfo, testSuite.getOwner());
        return testSuite;
    }

    @Inject
    public TestSuiteResource(CollectionDAO dao, Authorizer authorizer) {
        super(TestSuite.class, new TestSuiteRepository(dao), authorizer);
    }

    @GET
    @Operation(operationId="listTestSuites", summary="List test suites", tags={"TestSuites"}, description="Get a list of test suites. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of test definitions", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuiteList.class))})})
    public ResultList<TestSuite> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tests")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number test definitions returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of test definitions before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of test definitions after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTestSuiteVersion", summary="List test suite versions", tags={"TestSuites"}, description="Get a list of all the versions of a test suite identified by `id`", responses={@ApiResponse(responseCode="200", description="List of test suite versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Test Suite Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a Test Suite", tags={"TestSuites"}, description="Get a Test Suite by `id`.", responses={@ApiResponse(responseCode="200", description="The Test suite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="404", description="Test Suite for instance {id} is not found")})
    public TestSuite get(@Context UriInfo uriInfo, @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tests")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (TestSuite)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getTestSuiteByName", summary="Get a test suite by name", tags={"TestSuites"}, description="Get a test suite by  name.", responses={@ApiResponse(responseCode="200", description="The test suite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="404", description="Test Suite for instance {id} is not found")})
    public TestSuite getByName(@Context UriInfo uriInfo, @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tests")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (TestSuite)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificTestSuiteVersion", summary="Get a version of the TestSuite", tags={"TestSuites"}, description="Get a version of the test suite by given `id`", responses={@ApiResponse(responseCode="200", description="TestSuite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="404", description="Test Suite for instance {id} and version {version} is not found")})
    public TestSuite getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Test Suite Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="Test Suite version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (TestSuite)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createTestSuite", summary="Create a Test Suite", tags={"TestSuites"}, description="Create a Test suite.", responses={@ApiResponse(responseCode="200", description="The test suite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestSuite create) throws IOException {
        TestSuite testSuite = this.getTestSuite(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, testSuite);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchTestSuite", summary="Update a test suite", tags={"TestSuites"}, description="Update an existing testSuite using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateTestSuite", summary="Update test suite", tags={"TestSuites"}, description="Create a TestSuite, it it does not exist or update an existing test suite.", responses={@ApiResponse(responseCode="200", description="The updated test definition ", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestSuite create) throws IOException {
        TestSuite testSuite = this.getTestSuite(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, testSuite);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTestSuite", summary="Delete a test suite", tags={"TestSuites"}, description="Delete a test suite by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Test suite for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="TestSuite Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted TestSuite.", tags={"TestSuites"}, description="Restore a soft deleted TestSuite.", responses={@ApiResponse(responseCode="200", description="Successfully restored the TestSuite.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))})})
    public Response restoreTestSuite(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private TestSuite getTestSuite(CreateTestSuite create, String user) throws IOException {
        return this.copy(new TestSuite(), (CreateEntity)create, user).withDescription(create.getDescription()).withDisplayName(create.getDisplayName()).withName(create.getName());
    }

    public static class TestSuiteList
    extends ResultList<TestSuite> {
    }
}

