/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.database;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreateDatabaseService;
import org.openmetadata.schema.api.services.DatabaseConnection;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DatabaseServiceRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/services/databaseServices")
@Api(value="Database service collection", tags={"Services -> Database service collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="databaseServices")
public class DatabaseServiceResource
extends ServiceEntityResource<DatabaseService, DatabaseServiceRepository, DatabaseConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseServiceResource.class);
    public static final String COLLECTION_PATH = "v1/services/databaseServices/";
    static final String FIELDS = "pipelines,owner,tags";

    @Override
    public DatabaseService addHref(UriInfo uriInfo, DatabaseService service) {
        service.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, service.getId()));
        Entity.withHref(uriInfo, service.getOwner());
        Entity.withHref(uriInfo, service.getPipelines());
        return service;
    }

    public DatabaseServiceResource(CollectionDAO dao, Authorizer authorizer) {
        super(DatabaseService.class, new DatabaseServiceRepository(dao), authorizer, ServiceType.DATABASE);
    }

    @GET
    @Operation(operationId="listDatabaseServices", summary="List database services", tags={"databaseServices"}, description="Get a list of database services.", responses={@ApiResponse(responseCode="200", description="List of database service instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseServiceList.class))})})
    public ResultList<DatabaseService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of database services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of database services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        RestUtil.validateCursors(before, after);
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        ListFilter filter = new ListFilter(include);
        ResultList dbServices = before != null ? ((DatabaseServiceRepository)this.dao).listBefore(uriInfo, fields, filter, limitParam, before) : ((DatabaseServiceRepository)this.dao).listAfter(uriInfo, fields, filter, limitParam, after);
        return this.addHref(uriInfo, this.decryptOrNullify(securityContext, dbServices));
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDatabaseServiceByID", summary="Get a database service", tags={"databaseServices"}, description="Get a database service by `id`.", responses={@ApiResponse(responseCode="200", description="Database service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))}), @ApiResponse(responseCode="404", description="Database service for instance {id} is not found")})
    public DatabaseService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        DatabaseService databaseService = (DatabaseService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, databaseService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getDatabaseServiceByFQN", summary="Get database service by name", tags={"databaseServices"}, description="Get a database service by the service `name`.", responses={@ApiResponse(responseCode="200", description="Database service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))}), @ApiResponse(responseCode="404", description="Database service for instance {id} is not found")})
    public DatabaseService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        DatabaseService databaseService = (DatabaseService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        return this.decryptOrNullify(securityContext, databaseService);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDatabaseServiceVersion", summary="List database service versions", tags={"databaseServices"}, description="Get a list of all the versions of a database service identified by `id`", responses={@ApiResponse(responseCode="200", description="List of database service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="database service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                DatabaseService databaseService = JsonUtils.readValue((String)json, DatabaseService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, databaseService));
            }
            catch (IOException e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDatabaseServiceVersion", summary="Get a version of the database service", tags={"databaseServices"}, description="Get a version of the database service by given `id`", responses={@ApiResponse(responseCode="200", description="database service", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))}), @ApiResponse(responseCode="404", description="Database service for instance {id} and version {version} is not found")})
    public DatabaseService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="database service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="database service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        DatabaseService databaseService = (DatabaseService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, databaseService);
    }

    @Override
    @POST
    @Operation(operationId="createDatabaseService", summary="Create database service", tags={"databaseServices"}, description="Create a new database service.", responses={@ApiResponse(responseCode="200", description="Database service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDatabaseService create) throws IOException {
        DatabaseService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (DatabaseService)response.getEntity());
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDatabaseService", summary="Update database service", tags={"databaseServices"}, description="Update an existing or create a new database service.", responses={@ApiResponse(responseCode="200", description="Database service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDatabaseService update) throws IOException {
        DatabaseService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (DatabaseService)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDatabaseService", summary="Update a database service", tags={"databaseServices"}, description="Update an existing database service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDatabaseService", summary="Delete a database service", tags={"databaseServices"}, description="Delete a database services. If databases (and tables) belong the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DatabaseService service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the database service", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted DatabaseService.", tags={"databaseServices"}, description="Restore a soft deleted DatabaseService.", responses={@ApiResponse(responseCode="200", description="Successfully restored the DatabaseService.", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))})})
    public Response restoreDatabaseService(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private DatabaseService getService(CreateDatabaseService create, String user) throws IOException {
        return this.copy(new DatabaseService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected DatabaseService nullifyConnection(DatabaseService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(DatabaseService service) {
        return service.getServiceType().value();
    }

    public static class DatabaseServiceList
    extends ResultList<DatabaseService> {
    }
}

