/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.metadata;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreateMetadataService;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.services.MetadataConnection;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.services.connections.metadata.ComponentConfig;
import org.openmetadata.schema.services.connections.metadata.ElasticsSearch;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.MetadataServiceRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/services/metadataServices")
@Api(value="Metadata service collection", tags={"MetadataServices -> Metadata service collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="metadataServices")
public class MetadataServiceResource
extends ServiceEntityResource<MetadataService, MetadataServiceRepository, MetadataConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataServiceResource.class);
    public static final String COLLECTION_PATH = "v1/services/metadataServices/";
    public static final String FIELDS = "pipelines,owner,tags";

    @Override
    public void initialize(OpenMetadataApplicationConfig config) {
        this.registerMetadataServices(config);
    }

    private void registerMetadataServices(OpenMetadataApplicationConfig config) {
        try {
            if (config.getElasticSearchConfiguration() != null) {
                OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(config).build().withElasticsSearch(this.getElasticSearchConnectionSink(config.getElasticSearchConfiguration()));
                MetadataConnection metadataConnection = new MetadataConnection().withConfig((Object)openMetadataServerConnection);
                List<MetadataService> servicesList = ((MetadataServiceRepository)this.dao).getEntitiesFromSeedData(".*json/data/metadataService/.*\\.json$");
                servicesList.forEach(service -> {
                    try {
                        service.setConnection(metadataConnection);
                        service.setAllowServiceCreation(Boolean.valueOf(false));
                        ((MetadataServiceRepository)this.dao).initializeEntity(service);
                    }
                    catch (IOException e) {
                        LOG.error("[MetadataService] Failed to initialize a Metadata Service {}", (Object)service.getFullyQualifiedName(), (Object)e);
                    }
                });
            } else {
                LOG.error("[MetadataService] Missing Elastic Search Config");
            }
        }
        catch (Exception ex) {
            LOG.error("[MetadataService] Error in creating Metadata Services");
        }
    }

    @Override
    public MetadataService addHref(UriInfo uriInfo, MetadataService service) {
        service.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, service.getId()));
        Entity.withHref(uriInfo, service.getOwner());
        Entity.withHref(uriInfo, service.getPipelines());
        return service;
    }

    public MetadataServiceResource(CollectionDAO dao, Authorizer authorizer) {
        super(MetadataService.class, new MetadataServiceRepository(dao), authorizer, ServiceType.METADATA);
    }

    @GET
    @Operation(operationId="listMetadataServices", summary="List metadata services", tags={"metadataService"}, description="Get a list of metadata services.", responses={@ApiResponse(responseCode="200", description="List of Metadata Service instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataServiceList.class))})})
    public ResultList<MetadataService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of metadata services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of metadata services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        RestUtil.validateCursors(before, after);
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        ListFilter filter = new ListFilter(include);
        ResultList metadataServices = before != null ? ((MetadataServiceRepository)this.dao).listBefore(uriInfo, fields, filter, limitParam, before) : ((MetadataServiceRepository)this.dao).listAfter(uriInfo, fields, filter, limitParam, after);
        return this.addHref(uriInfo, this.decryptOrNullify(securityContext, metadataServices));
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getMetadataServiceByID", summary="Get a Metadata Service", tags={"metadataService"}, description="Get a Metadata Service by `id`.", responses={@ApiResponse(responseCode="200", description="Metadata Service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataService.class))}), @ApiResponse(responseCode="404", description="Metadata Service for instance {id} is not found")})
    public MetadataService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        MetadataService metadataService = (MetadataService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, metadataService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getMetadataServiceByFQN", summary="Get Metadata Service by name", tags={"metadataService"}, description="Get a Metadata Service by the service `name`.", responses={@ApiResponse(responseCode="200", description="Metadata Service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataService.class))}), @ApiResponse(responseCode="404", description="Metadata Service for instance {id} is not found")})
    public MetadataService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        MetadataService metadataService = (MetadataService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        return this.decryptOrNullify(securityContext, metadataService);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllMetadataServiceVersion", summary="List Metadata Service versions", tags={"metadataService"}, description="Get a list of all the versions of a Metadata Service identified by `id`", responses={@ApiResponse(responseCode="200", description="List of Metadata Service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Metadata Service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                MetadataService MetadataService2 = JsonUtils.readValue((String)json, MetadataService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, MetadataService2));
            }
            catch (IOException e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificMetadataServiceVersion", summary="Get a version of the Metadata Service", tags={"metadataService"}, description="Get a version of the Metadata Service by given `id`", responses={@ApiResponse(responseCode="200", description="Metadata Service", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataService.class))}), @ApiResponse(responseCode="404", description="Metadata Service for instance {id} and version {version} is not found")})
    public MetadataService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Metadata Service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="Metadata Service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        MetadataService metadataService = (MetadataService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, metadataService);
    }

    @Override
    @POST
    @Operation(operationId="createMetadataService", summary="Create Metadata Service", tags={"metadataService"}, description="Create a new Metadata Service.", responses={@ApiResponse(responseCode="200", description="Metadata Service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateMetadataService create) throws IOException {
        MetadataService service = this.getMetadataService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (MetadataService)response.getEntity());
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateMetadataService", summary="Update Metadata Service", tags={"metadataService"}, description="Update an existing or create a new Metadata Service.", responses={@ApiResponse(responseCode="200", description="Metadata Service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetadataService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateMetadataService update) throws IOException {
        MetadataService service = this.getMetadataService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (MetadataService)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchMetadataService", summary="Update a Metadata service", tags={"metadataService"}, description="Update an existing Metadata service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteMetadataService", summary="Delete a Metadata Service", tags={"metadataService"}, description="Delete a metadata services. If some service belong the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="MetadataService service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the Metadata Service", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted metadata service.", tags={"metadataService"}, description="Restore a soft deleted metadata service.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Response restoreTable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private MetadataService getMetadataService(CreateMetadataService create, String user) throws IOException {
        return this.copy(new MetadataService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected MetadataService nullifyConnection(MetadataService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(MetadataService service) {
        return service.getServiceType().value();
    }

    private ElasticsSearch getElasticSearchConnectionSink(ElasticSearchConfiguration esConfig) {
        if (Objects.nonNull(esConfig)) {
            ElasticsSearch sink = new ElasticsSearch();
            ComponentConfig componentConfig = new ComponentConfig();
            sink.withType("elasticsearch").withConfig(componentConfig.withAdditionalProperty("es_host", esConfig.getHost()).withAdditionalProperty("es_port", esConfig.getPort().toString()).withAdditionalProperty("es_username", esConfig.getUsername()).withAdditionalProperty("es_password", esConfig.getPassword()).withAdditionalProperty("scheme", esConfig.getScheme()));
            return sink;
        }
        throw new RuntimeException("Elastic Search Configuration Missing");
    }

    public static class MetadataServiceList
    extends ResultList<MetadataService> {
    }
}

