/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.settings;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.SettingsRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/settings")
@Api(value="Settings Collection", tags={"Settings collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="settings")
public class SettingsResource {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsResource.class);
    private final SettingsRepository settingsRepository;
    private final Authorizer authorizer;

    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        this.initSettings();
    }

    private void initSettings() throws IOException {
        List<String> jsonDataFiles = EntityUtil.getJsonDataResources(".*json/data/settings/settingsData.json$");
        if (jsonDataFiles.size() != 1) {
            LOG.warn("Invalid number of jsonDataFiles {}. Only one expected.", (Object)jsonDataFiles.size());
            return;
        }
        String jsonDataFile = jsonDataFiles.get(0);
        try {
            String json = CommonUtil.getResourceAsStream((ClassLoader)this.getClass().getClassLoader(), (String)jsonDataFile);
            List<Settings> settings = JsonUtils.readObjects(json, Settings.class);
            settings.forEach(setting -> {
                try {
                    Settings storedSettings = this.settingsRepository.getConfigWithKey(setting.getConfigType().toString());
                    if (storedSettings == null) {
                        this.settingsRepository.createNewSetting((Settings)setting);
                    }
                }
                catch (Exception ex) {
                    LOG.debug("Fetching from DB failed ", (Throwable)ex);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize the {} from file {}", new Object[]{"filters", jsonDataFile, e});
        }
    }

    public SettingsResource(CollectionDAO dao, Authorizer authorizer) {
        Objects.requireNonNull(dao, "SettingsRepository must not be null");
        this.settingsRepository = new SettingsRepository(dao);
        SettingsCache.initialize(dao);
        this.authorizer = authorizer;
    }

    @GET
    @Operation(operationId="listSettings", summary="List All Settings", tags={"settings"}, description="Get a List of all OpenMetadata Settings", responses={@ApiResponse(responseCode="200", description="List of Settings", content={@Content(mediaType="application/json", schema=@Schema(implementation=SettingsList.class))})})
    public ResultList<Settings> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext);
        return this.settingsRepository.listAllConfigs();
    }

    @GET
    @Path(value="/{settingName}")
    @Operation(operationId="getSetting", summary="Get a Setting", tags={"settings"}, description="Get a OpenMetadata Settings", responses={@ApiResponse(responseCode="200", description="Settings", content={@Content(mediaType="application/json", schema=@Schema(implementation=Settings.class))})})
    public Settings getSettingByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="settingName") String settingName) {
        this.authorizer.authorizeAdmin(securityContext);
        return this.settingsRepository.getConfigWithKey(settingName);
    }

    @PUT
    @Operation(operationId="createOrUpdate", summary="Update Setting", tags={"settings"}, description="Update Existing Settings", responses={@ApiResponse(responseCode="200", description="Settings", content={@Content(mediaType="application/json", schema=@Schema(implementation=Settings.class))})})
    public Response createOrUpdateSetting(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid Settings settingName) {
        this.authorizer.authorizeAdmin(securityContext);
        return this.settingsRepository.createOrUpdate(settingName);
    }

    @PATCH
    @Path(value="/{settingName}")
    @Operation(operationId="patchSetting", summary="Patch a Setting", tags={"settings"}, description="Update an existing Setting using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Key of the Setting", schema=@Schema(type="string")) @PathParam(value="settingName") String settingName, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        this.authorizer.authorizeAdmin(securityContext);
        return this.settingsRepository.patchSetting(settingName, patch);
    }

    public static class SettingsList
    extends ResultList<Settings> {
    }
}

