/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.tags;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.type.TagCategory;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLabelCache {
    private static final Logger LOG = LoggerFactory.getLogger(TagLabelCache.class);
    private static final TagLabelCache INSTANCE = new TagLabelCache();
    private static volatile boolean INITIALIZED = false;
    protected static EntityRepository<Tag> TAG_REPOSITORY;
    protected static EntityRepository<TagCategory> TAG_CATEGORY_REPOSITORY;
    protected static LoadingCache<String, Tag> TAG_CACHE;
    protected static LoadingCache<String, TagCategory> TAG_CATEGORY_CACHE;
    protected static EntityRepository<GlossaryTerm> GLOSSARY_TERM_REPOSITORY;
    protected static EntityRepository<Glossary> GLOSSARY_REPOSITORY;
    protected static LoadingCache<String, GlossaryTerm> GLOSSARY_TERM_CACHE;
    protected static LoadingCache<String, Glossary> GLOSSARY_CACHE;

    public static void initialize() {
        if (!INITIALIZED) {
            TAG_CATEGORY_CACHE = CacheBuilder.newBuilder().maximumSize(25L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new TagCategoryLoader());
            TAG_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new TagLoader());
            TAG_REPOSITORY = Entity.getEntityRepository("tag");
            TAG_CATEGORY_REPOSITORY = Entity.getEntityRepository("tagCategory");
            GLOSSARY_CACHE = CacheBuilder.newBuilder().maximumSize(25L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new GlossaryLoader());
            GLOSSARY_TERM_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new GlossaryTermLoader());
            GLOSSARY_TERM_REPOSITORY = Entity.getEntityRepository("glossaryTerm");
            GLOSSARY_REPOSITORY = Entity.getEntityRepository("glossary");
            INITIALIZED = true;
        } else {
            LOG.info("Subject cache is already initialized");
        }
    }

    public static TagLabelCache getInstance() {
        return INSTANCE;
    }

    public TagCategory getTagCategory(String categoryName) {
        try {
            return (TagCategory)TAG_CATEGORY_CACHE.get((Object)categoryName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public Tag getTag(String tagFqn) {
        try {
            return (Tag)TAG_CACHE.get((Object)tagFqn);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public Glossary getGlossary(String glossaryName) {
        try {
            return (Glossary)GLOSSARY_CACHE.get((Object)glossaryName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public GlossaryTerm getGlossaryTerm(String glossaryTermFqn) {
        try {
            return (GlossaryTerm)GLOSSARY_TERM_CACHE.get((Object)glossaryTermFqn);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public String getDescription(TagLabel label) {
        if (label.getSource() == TagLabel.TagSource.TAG) {
            return this.getTag(label.getTagFQN()).getDescription();
        }
        if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            return this.getGlossaryTerm(label.getTagFQN()).getDescription();
        }
        throw new IllegalArgumentException("Invalid source type " + String.valueOf(label.getSource()));
    }

    public boolean mutuallyExclusive(TagLabel label) {
        boolean rootParent;
        String parentFqn = FullyQualifiedName.getParent(label.getTagFQN());
        boolean bl = rootParent = FullyQualifiedName.split(parentFqn).length == 1;
        if (label.getSource() == TagLabel.TagSource.TAG) {
            return rootParent ? this.getTagCategory(parentFqn).getMutuallyExclusive() : this.getTag(parentFqn).getMutuallyExclusive();
        }
        if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            return rootParent ? this.getGlossary(parentFqn).getMutuallyExclusive() : this.getGlossaryTerm(parentFqn).getMutuallyExclusive();
        }
        throw new IllegalArgumentException("Invalid source type " + String.valueOf(label.getSource()));
    }

    static class TagCategoryLoader
    extends CacheLoader<String, TagCategory> {
        TagCategoryLoader() {
        }

        public TagCategory load(@CheckForNull String categoryName) throws IOException {
            TagCategory category = TAG_CATEGORY_REPOSITORY.getByName(null, categoryName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded user {}:{}", (Object)category.getName(), (Object)category.getId());
            return category;
        }
    }

    static class TagLoader
    extends CacheLoader<String, Tag> {
        TagLoader() {
        }

        public Tag load(@CheckForNull String tagName) throws IOException {
            Tag tag = TAG_REPOSITORY.getByName(null, tagName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded user {}:{}", (Object)tag.getName(), (Object)tag.getId());
            return tag;
        }
    }

    static class GlossaryLoader
    extends CacheLoader<String, Glossary> {
        GlossaryLoader() {
        }

        public Glossary load(@CheckForNull String glossaryName) throws IOException {
            Glossary glossary = GLOSSARY_REPOSITORY.getByName(null, glossaryName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded user {}:{}", (Object)glossary.getName(), (Object)glossary.getId());
            return glossary;
        }
    }

    static class GlossaryTermLoader
    extends CacheLoader<String, GlossaryTerm> {
        GlossaryTermLoader() {
        }

        public GlossaryTerm load(@CheckForNull String glossaryTermName) throws IOException {
            GlossaryTerm glossaryTerm = GLOSSARY_TERM_REPOSITORY.getByName(null, glossaryTermName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded user {}:{}", (Object)glossaryTerm.getName(), (Object)glossaryTerm.getId());
            return glossaryTerm;
        }
    }
}

