/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.tags;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.tags.CreateTag;
import org.openmetadata.schema.api.tags.CreateTagCategory;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.TagCategory;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TagCategoryRepository;
import org.openmetadata.service.jdbi3.TagRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.tags.TagLabelCache;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/tags")
@Api(value="Tags resources collection", tags={"Tags resources collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="tags", order=6)
public class TagResource {
    private static final Logger LOG = LoggerFactory.getLogger(TagResource.class);
    public static final String TAG_COLLECTION_PATH = "/v1/tags/";
    private final TagRepository dao;
    private final TagCategoryRepository daoCategory;
    private final Authorizer authorizer;
    static final String FIELDS = "usageCount";
    protected static final List<String> ALLOWED_FIELDS = Entity.getEntityFields(Tag.class);

    public TagResource(CollectionDAO collectionDAO, Authorizer authorizer) {
        Objects.requireNonNull(collectionDAO, "TagRepository must not be null");
        this.dao = new TagRepository(collectionDAO);
        this.daoCategory = new TagCategoryRepository(collectionDAO, this.dao);
        this.authorizer = authorizer;
    }

    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        List<TagCategory> tagCategories = EntityRepository.getEntitiesFromSeedData("tagCategory", ".*json/data/tags/.*\\.json$", TagCategory.class);
        for (TagCategory tagCategory : tagCategories) {
            long now = System.currentTimeMillis();
            tagCategory.withId(UUID.randomUUID()).withUpdatedBy("admin").withUpdatedAt(Long.valueOf(now));
            tagCategory.getChildren().forEach(t -> {
                t.withId(UUID.randomUUID()).withUpdatedBy("admin").withUpdatedAt(Long.valueOf(now)).withProvider(tagCategory.getProvider());
                t.getChildren().forEach(c -> c.withId(UUID.randomUUID()).withUpdatedBy("admin").withUpdatedAt(Long.valueOf(now)).withProvider(tagCategory.getProvider()));
            });
            this.daoCategory.initCategory(tagCategory);
            TagLabelCache.initialize();
        }
    }

    @GET
    @Operation(operationId="listTagCategories", summary="List tag categories", tags={"tags"}, description="Get a list of tag categories.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=CategoryList.class))})})
    public ResultList<TagCategory> getCategories(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="usageCount")) @QueryParam(value="fields") String fieldsParam) throws IOException {
        EntityUtil.Fields fields = new EntityUtil.Fields(ALLOWED_FIELDS, fieldsParam);
        ListFilter filter = new ListFilter(Include.ALL);
        ResultList<TagCategory> list = this.daoCategory.listAfter(uriInfo, fields, filter, 10000, null);
        list.getData().forEach(category -> this.addHref(uriInfo, (TagCategory)category));
        return list;
    }

    @GET
    @Path(value="{category}")
    @Operation(operationId="getTagCategoryByName", summary="Get a tag category", tags={"tags"}, description="Get a tag category identified by name. The response includes tag category information along with the entire hierarchy of all the children tags.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagCategory.class))}), @ApiResponse(responseCode="404", description="TagCategory for instance {category} is not found")})
    public TagCategory getCategory(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String category, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="usageCount")) @QueryParam(value="fields") String fieldsParam) throws IOException {
        EntityUtil.Fields fields = new EntityUtil.Fields(ALLOWED_FIELDS, fieldsParam);
        return this.addHref(uriInfo, (TagCategory)this.daoCategory.getByName(uriInfo, category, fields, Include.ALL));
    }

    @GET
    @Operation(operationId="getPrimaryTag", summary="Get a primary tag", tags={"tags"}, description="Get a primary tag identified by name. The response includes with the entire hierarchy of all the children tags.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Tag.class))}), @ApiResponse(responseCode="404", description="TagCategory for instance {category} is not found"), @ApiResponse(responseCode="404", description="Tag for instance {primaryTag} is not found")})
    @Path(value="{category}/{primaryTag}")
    @ApiOperation(value="Returns tag groups under the given category.", response=Tag.class)
    public Tag getPrimaryTag(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String category, @Parameter(description="Primary tag name", schema=@Schema(type="string", example="<primaryTag> fully qualified name <categoryName>.<primaryTag>")) @PathParam(value="primaryTag") String primaryTag, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="usageCount")) @QueryParam(value="fields") String fieldsParam) throws IOException {
        String fqn = FullyQualifiedName.add(category, primaryTag);
        EntityUtil.Fields fields = new EntityUtil.Fields(ALLOWED_FIELDS, fieldsParam);
        Tag tag = (Tag)this.dao.getByName(uriInfo, fqn, fields, Include.ALL);
        URI categoryHref = RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, category);
        return this.addHref(categoryHref, tag);
    }

    @GET
    @Path(value="{category}/{primaryTag}/{secondaryTag}")
    @Operation(operationId="getSecondaryTag", summary="Get a secondary tag", tags={"tags"}, description="Get a secondary tag identified by name.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Tag.class))}), @ApiResponse(responseCode="404", description="TagCategory for instance {category} is not found"), @ApiResponse(responseCode="404", description="Tag for instance {primaryTag} is not found"), @ApiResponse(responseCode="404", description="Tag for instance {secondaryTag} is not found")})
    public Tag getSecondaryTag(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String category, @Parameter(description="Primary tag name", schema=@Schema(type="string", example="<primaryTag> fully qualified name <categoryName>.<primaryTag>")) @PathParam(value="primaryTag") String primaryTag, @Parameter(description="Secondary tag name", schema=@Schema(type="string", example="<secondaryTag> fully qualified name <categoryName>.<primaryTag>.<SecondaryTag>")) @PathParam(value="secondaryTag") String secondaryTag, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="usageCount")) @QueryParam(value="fields") String fieldsParam) throws IOException {
        String fqn = FullyQualifiedName.build(category, primaryTag, secondaryTag);
        EntityUtil.Fields fields = new EntityUtil.Fields(ALLOWED_FIELDS, fieldsParam);
        Tag tag = (Tag)this.dao.getByName(uriInfo, fqn, fields, Include.ALL);
        URI categoryHref = RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, category + "/" + primaryTag);
        return this.addHref(categoryHref, tag);
    }

    @POST
    @Operation(operationId="createTagCategory", summary="Create a tag category", tags={"tags"}, description="Create a new tag category. The request can include the children tags to be created along with the tag category.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagCategory.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createCategory(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTagCategory create) throws IOException {
        OperationContext operationContext = new OperationContext("tagCategory", MetadataOperation.CREATE);
        ResourceContext resourceContext = EntityResource.getResourceContext("tagCategory", this.daoCategory).build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        TagCategory category = this.getTagCategory(securityContext, create);
        category = this.addHref(uriInfo, this.daoCategory.create(uriInfo, category));
        return Response.created((URI)category.getHref()).entity((Object)category).build();
    }

    @POST
    @Path(value="{category}")
    @Operation(operationId="createPrimaryTag", summary="Create a primary tag", tags={"tags"}, description="Create a primary tag in the given tag category.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Tag.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createPrimaryTag(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String category, @Valid CreateTag create) throws IOException {
        OperationContext operationContext = new OperationContext("tag", MetadataOperation.CREATE);
        ResourceContext resourceContext = EntityResource.getResourceContext("tag", this.dao).build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        Tag tag = this.getTag(securityContext, create, FullyQualifiedName.build(category));
        URI categoryHref = RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, category);
        tag = this.addHref(categoryHref, this.dao.create(uriInfo, tag));
        return Response.created((URI)tag.getHref()).entity((Object)tag).build();
    }

    @POST
    @Path(value="{category}/{primaryTag}")
    @Operation(operationId="createSecondaryTag", summary="Create a secondary tag", tags={"tags"}, description="Create a secondary tag under the given primary tag.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Tag.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createSecondaryTag(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String category, @Parameter(description="Primary tag name", schema=@Schema(type="string", example="<primaryTag> fully qualified name <categoryName>.<primaryTag>")) @PathParam(value="primaryTag") String primaryTag, @Valid CreateTag create) throws IOException {
        OperationContext operationContext = new OperationContext("tag", MetadataOperation.CREATE);
        ResourceContext resourceContext = EntityResource.getResourceContext("tag", this.dao).build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        Tag tag = this.getTag(securityContext, create, FullyQualifiedName.build(category, primaryTag));
        URI categoryHref = RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, category);
        URI parentHRef = RestUtil.getHref(categoryHref, primaryTag);
        tag = this.addHref(parentHRef, this.dao.create(uriInfo, tag));
        return Response.created((URI)tag.getHref()).entity((Object)tag).build();
    }

    @PUT
    @Path(value="{category}")
    @Operation(operationId="createOrUpdateTagCategory", summary="Update a tag category", tags={"tags"}, description="Update an existing category identify by category name")
    public Response updateCategory(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String categoryName, @Valid CreateTagCategory create) throws IOException {
        TagCategory category = this.getTagCategory(securityContext, create);
        ResourceContext resourceContext = EntityResource.getResourceContext("tagCategory", this.daoCategory).name(categoryName).build();
        OperationContext operationContext = new OperationContext("tagCategory", EntityUtil.createOrUpdateOperation(resourceContext));
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        if (categoryName.equals(create.getName())) {
            category = this.addHref(uriInfo, this.daoCategory.createOrUpdate(uriInfo, category).getEntity());
        } else {
            TagCategory origCategory = this.getTagCategory(securityContext, create).withName(categoryName).withFullyQualifiedName(categoryName);
            category = this.addHref(uriInfo, this.daoCategory.createOrUpdate(uriInfo, origCategory, category).getEntity());
        }
        return Response.ok((Object)category).build();
    }

    @PUT
    @Path(value="{category}/{primaryTag}")
    @Operation(operationId="createOrUpdatePrimaryTag", summary="Update a primaryTag", tags={"tags"}, description="Update an existing primaryTag identify by name")
    public Response updatePrimaryTag(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String categoryName, @Parameter(description="Primary tag name", schema=@Schema(type="string", example="<primaryTag> fully qualified name <categoryName>.<primaryTag>")) @PathParam(value="primaryTag") String primaryTag, @Valid CreateTag create) throws IOException {
        RestUtil.PutResponse<Tag> response;
        Tag tag = this.getTag(securityContext, create, FullyQualifiedName.build(categoryName));
        ResourceContext resourceContext = EntityResource.getResourceContext("tag", this.dao).name(categoryName).build();
        OperationContext operationContext = new OperationContext("tag", EntityUtil.createOrUpdateOperation(resourceContext));
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        URI categoryHref = RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, categoryName);
        if (primaryTag.equals(create.getName())) {
            response = this.dao.createOrUpdate(uriInfo, tag);
        } else {
            Tag origTag = this.getTag(securityContext, create, FullyQualifiedName.build(categoryName)).withName(primaryTag).withFullyQualifiedName(FullyQualifiedName.build(categoryName, primaryTag));
            response = this.dao.createOrUpdate(uriInfo, origTag, tag);
        }
        this.addHref(categoryHref, response.getEntity());
        return response.toResponse();
    }

    @PUT
    @Path(value="{category}/{primaryTag}/{secondaryTag}")
    @Operation(operationId="createOrUpdateSecondaryTag", summary="Update a secondaryTag", tags={"tags"}, description="Update an existing secondaryTag identify by name")
    public Response updateSecondaryTag(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String categoryName, @Parameter(description="Primary tag name", schema=@Schema(type="string", example="<primaryTag> fully qualified name <categoryName>.<primaryTag>")) @PathParam(value="primaryTag") String primaryTag, @Parameter(description="SecondaryTag tag name", schema=@Schema(type="string", example="<secondaryTag> fully qualified name <categoryName>.<primaryTag>.<secondaryTag>")) @PathParam(value="secondaryTag") String secondaryTag, @Valid CreateTag create) throws IOException {
        RestUtil.PutResponse<Tag> response;
        Tag tag = this.getTag(securityContext, create, FullyQualifiedName.build(categoryName, primaryTag));
        ResourceContext resourceContext = EntityResource.getResourceContext("tag", this.dao).name(tag.getFullyQualifiedName()).build();
        OperationContext operationContext = new OperationContext("tag", EntityUtil.createOrUpdateOperation(resourceContext));
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        if (secondaryTag.equals(create.getName())) {
            response = this.dao.createOrUpdate(uriInfo, tag);
        } else {
            Tag origTag = this.getTag(securityContext, create, FullyQualifiedName.build(categoryName, primaryTag)).withName(secondaryTag);
            response = this.dao.createOrUpdate(uriInfo, origTag, tag);
        }
        URI categoryHref = RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, categoryName);
        URI parentHRef = RestUtil.getHref(categoryHref, primaryTag);
        this.addHref(parentHRef, response.getEntity());
        return response.toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTagCategory", summary="Delete tag category", tags={"tags"}, description="Delete a tag category and all the tags under it.")
    public Response deleteCategory(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        OperationContext operationContext = new OperationContext("tagCategory", MetadataOperation.DELETE);
        ResourceContext resourceContext = EntityResource.getResourceContext("tagCategory", this.daoCategory).id(id).build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        TagCategory tagCategory = this.daoCategory.delete(uriInfo, id);
        this.addHref(uriInfo, tagCategory);
        return new RestUtil.DeleteResponse<TagCategory>(tagCategory, "entityDeleted").toResponse();
    }

    @DELETE
    @Path(value="/{category}/{id}")
    @Operation(operationId="deleteTags", summary="Delete tag", tags={"tags"}, description="Delete a tag and all the tags under it.")
    public Response deleteTags(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Tag category name", schema=@Schema(type="string")) @PathParam(value="category") String category, @Parameter(description="Tag id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        OperationContext operationContext = new OperationContext("tag", MetadataOperation.DELETE);
        ResourceContext resourceContext = EntityResource.getResourceContext("tag", this.dao).id(id).build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        Tag tag = this.dao.delete(uriInfo, id);
        URI categoryHref = RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, category);
        this.addHref(categoryHref, tag);
        return new RestUtil.DeleteResponse<Tag>(tag, "entityDeleted").toResponse();
    }

    private TagCategory addHref(UriInfo uriInfo, TagCategory category) {
        category.setHref(RestUtil.getHref(uriInfo, TAG_COLLECTION_PATH, category.getName()));
        this.addHref(category.getHref(), category.getChildren());
        return category;
    }

    private void addHref(URI parentHref, List<Tag> tags) {
        for (Tag tag : CommonUtil.listOrEmpty(tags)) {
            this.addHref(parentHref, tag);
        }
    }

    private Tag addHref(URI parentHref, Tag tag) {
        tag.setHref(RestUtil.getHref(parentHref, tag.getName()));
        this.addHref(tag.getHref(), tag.getChildren());
        return tag;
    }

    private TagCategory getTagCategory(SecurityContext securityContext, CreateTagCategory create) {
        return new TagCategory().withId(UUID.randomUUID()).withName(create.getName()).withFullyQualifiedName(create.getName()).withMutuallyExclusive(create.getMutuallyExclusive()).withDescription(create.getDescription()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
    }

    private Tag getTag(SecurityContext securityContext, CreateTag create, String parentFQN) {
        return new Tag().withId(UUID.randomUUID()).withName(create.getName()).withFullyQualifiedName(FullyQualifiedName.add(parentFQN, create.getName())).withDescription(create.getDescription()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withMutuallyExclusive(create.getMutuallyExclusive());
    }

    static class CategoryList
    extends ResultList<TagCategory> {
        CategoryList() {
        }
    }
}

