/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.types;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.CreateType;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.type.Category;
import org.openmetadata.schema.entity.type.CustomProperty;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TypeRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/metadata/types")
@Api(value="Types collection", tags={"metadata"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="types")
public class TypeResource
extends EntityResource<Type, TypeRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(TypeResource.class);
    public static final String COLLECTION_PATH = "v1/metadata/types/";
    public static final String PROPERTIES = "customProperties";

    @Override
    public Type addHref(UriInfo uriInfo, Type type) {
        CommonUtil.listOrEmpty((List)type.getCustomProperties()).forEach(property -> Entity.withHref(uriInfo, property.getPropertyType()));
        return type;
    }

    @Inject
    public TypeResource(CollectionDAO dao, Authorizer authorizer) {
        super(Type.class, new TypeRepository(dao), authorizer);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        long now = System.currentTimeMillis();
        List<Type> types = JsonUtils.getTypes();
        types.forEach(type -> {
            type.withId(UUID.randomUUID()).withUpdatedBy("admin").withUpdatedAt(Long.valueOf(now));
            LOG.info("Loading type {}", (Object)type.getName());
            try {
                EntityUtil.Fields fields = this.getFields(PROPERTIES);
                try {
                    Type storedType = (Type)((TypeRepository)this.dao).getByName(null, type.getName(), fields);
                    type.setId(storedType.getId());
                    if (storedType.getCategory().equals((Object)Category.Entity)) {
                        type.setCustomProperties(storedType.getCustomProperties());
                    }
                }
                catch (Exception e) {
                    LOG.debug("Creating entity that does not exist ", (Throwable)e);
                }
                ((TypeRepository)this.dao).createOrUpdate(null, type);
                ((TypeRepository)this.dao).addToRegistry((Type)type);
            }
            catch (Exception e) {
                LOG.error("Error loading type {}", (Object)type.getName(), (Object)e);
            }
        });
    }

    @GET
    @Valid
    @Operation(operationId="listTypes", summary="List types", tags={"metadata"}, description="Get a list of types. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of types", content={@Content(mediaType="application/json", schema=@Schema(implementation=TypeList.class))})})
    public ResultList<Type> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Filter types by metadata type category.", schema=@Schema(type="string", example="Property, Entity")) @QueryParam(value="category") String categoryParam, @Parameter(description="Limit the number types returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of types before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of types after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) throws IOException {
        ListFilter filter = new ListFilter(Include.ALL).addQueryParam("category", categoryParam);
        return super.listInternal(uriInfo, securityContext, "", filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getTypeByID", summary="Get a type", tags={"metadata"}, description="Get a type by `id`.", responses={@ApiResponse(responseCode="200", description="The type", content={@Content(mediaType="application/json", schema=@Schema(implementation=Type.class))}), @ApiResponse(responseCode="404", description="Type for instance {id} is not found")})
    public Type get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="customProperties")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Type)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getTypeByFQN", summary="Get a type by name", tags={"metadata"}, description="Get a type by name.", responses={@ApiResponse(responseCode="200", description="The type", content={@Content(mediaType="application/json", schema=@Schema(implementation=Type.class))}), @ApiResponse(responseCode="404", description="Type for instance {id} is not found")})
    public Type getByName(@Context UriInfo uriInfo, @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="customProperties")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Type)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTypeVersion", summary="List type versions", tags={"metadata"}, description="Get a list of all the versions of a type identified by `id`", responses={@ApiResponse(responseCode="200", description="List of type versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="type Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificTypeVersion", summary="Get a version of the types", tags={"metadata"}, description="Get a version of the type by given `id`", responses={@ApiResponse(responseCode="200", description="types", content={@Content(mediaType="application/json", schema=@Schema(implementation=Type.class))}), @ApiResponse(responseCode="404", description="Type for instance {id} and version {version} is not found")})
    public Type getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="type Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="type version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Type)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createType", summary="Create a type", tags={"metadata"}, description="Create a new type.", responses={@ApiResponse(responseCode="200", description="The type", content={@Content(mediaType="application/json", schema=@Schema(implementation=Type.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateType create) throws IOException {
        Type type = this.getType(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, type);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchType", summary="Update a type", tags={"metadata"}, description="Update an existing type using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(summary="Create or update a type", tags={"metadata"}, description="Create a new type, if it does not exist or update an existing type.", responses={@ApiResponse(responseCode="200", description="The type", content={@Content(mediaType="application/json", schema=@Schema(implementation=Type.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateType create) throws IOException {
        Type type = this.getType(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, type);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteType", summary="Delete a type", tags={"metadata"}, description="Delete a type by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="type for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Type Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, false, true);
    }

    @PUT
    @Path(value="/{id}")
    @Operation(operationId="addProperty", summary="Add or update a Property to an entity", tags={"metadata"}, description="Add or update a property to an entity type. Properties can only be added to entity type and not property type.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="type for instance {id} is not found")})
    public Response addOrUpdateProperty(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Type Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Valid CustomProperty property) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        RestUtil.PutResponse<Type> response = ((TypeRepository)this.dao).addCustomProperty(uriInfo, securityContext.getUserPrincipal().getName(), id, property);
        this.addHref(uriInfo, response.getEntity());
        return response.toResponse();
    }

    private Type getType(CreateType create, String user) throws IOException {
        return this.copy(new Type(), (CreateEntity)create, user).withFullyQualifiedName(create.getName()).withCategory(create.getCategory()).withSchema(create.getSchema());
    }

    public static class TypeList
    extends ResultList<Type> {
        TypeList() {
        }
    }
}

