/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotTokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(BotTokenCache.class);
    public static final String EMPTY_STRING = "";
    private static BotTokenCache INSTANCE;
    private final LoadingCache<String, String> BOTS_TOKEN_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new BotTokenLoader());

    public String getToken(String botName) {
        try {
            if (((String)this.BOTS_TOKEN_CACHE.get((Object)botName)).equals(EMPTY_STRING)) {
                this.BOTS_TOKEN_CACHE.invalidate((Object)botName);
            }
            return (String)this.BOTS_TOKEN_CACHE.get((Object)botName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            return null;
        }
    }

    public void invalidateToken(String botName) {
        try {
            this.BOTS_TOKEN_CACHE.invalidate((Object)botName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate Bot token cache for Bot {}", (Object)botName, (Object)ex);
        }
    }

    public static BotTokenCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BotTokenCache();
        }
        return INSTANCE;
    }

    static class BotTokenLoader
    extends CacheLoader<String, String> {
        BotTokenLoader() {
        }

        public String load(@CheckForNull String botName) throws IOException {
            UserRepository userRepository = (UserRepository)UserRepository.class.cast(Entity.getEntityRepository("user"));
            User user = (User)userRepository.getByName(null, botName, new EntityUtil.Fields(List.of("authenticationMechanism")), Include.NON_DELETED);
            AuthenticationMechanism authenticationMechanism = user.getAuthenticationMechanism();
            if (authenticationMechanism != null) {
                JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authenticationMechanism.getConfig(), JWTAuthMechanism.class);
                return jwtAuthMechanism.getJWTToken();
            }
            return null;
        }
    }
}

