/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.DbtPipeline;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtCloudConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtGCSConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtHttpConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtLocalConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtS3Config;
import org.openmetadata.schema.security.client.Auth0SSOClientConfig;
import org.openmetadata.schema.security.client.AzureSSOClientConfig;
import org.openmetadata.schema.security.client.CustomOIDCSSOClientConfig;
import org.openmetadata.schema.security.client.GoogleSSOClientConfig;
import org.openmetadata.schema.security.client.OktaSSOClientConfig;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.service.util.JsonUtils;

public class IngestionPipelineBuilder {
    private static final List<Class<?>> DBT_CONFIG_CLASSES = List.of(DbtCloudConfig.class, DbtGCSConfig.class, DbtHttpConfig.class, DbtLocalConfig.class, DbtS3Config.class);
    private static final List<Class<?>> SECURITY_CONFIG_CLASSES = List.of(OpenMetadataJWTClientConfig.class, GoogleSSOClientConfig.class, OktaSSOClientConfig.class, Auth0SSOClientConfig.class, AzureSSOClientConfig.class, CustomOIDCSSOClientConfig.class);

    public static IngestionPipeline build(IngestionPipeline ingestionPipeline) {
        if (PipelineType.DBT.equals((Object)ingestionPipeline.getPipelineType())) {
            DbtPipeline dbtPipeline = JsonUtils.convertValue(ingestionPipeline.getSourceConfig().getConfig(), DbtPipeline.class);
            ingestionPipeline.getSourceConfig().setConfig((Object)dbtPipeline.withDbtConfigSource(IngestionPipelineBuilder.buildDbtConfigSource(dbtPipeline.getDbtConfigSource())));
        }
        if (ingestionPipeline.getOpenMetadataServerConnection() != null) {
            ingestionPipeline.getOpenMetadataServerConnection().setSecurityConfig(IngestionPipelineBuilder.buildSecurityConfig(ingestionPipeline.getOpenMetadataServerConnection().getSecurityConfig()));
        }
        return ingestionPipeline;
    }

    private static Object buildDbtConfigSource(Object config) {
        return IngestionPipelineBuilder.buildBasedOnClassList(config, DBT_CONFIG_CLASSES);
    }

    private static Object buildSecurityConfig(Object config) {
        return IngestionPipelineBuilder.buildBasedOnClassList(config, SECURITY_CONFIG_CLASSES);
    }

    @Nullable
    private static Object buildBasedOnClassList(Object config, List<Class<?>> listOfClasses) {
        if (config != null) {
            for (Class<?> clazz : listOfClasses) {
                try {
                    return JsonUtils.convertValue(config, clazz);
                }
                catch (Exception exception) {
                }
            }
            throw new IllegalArgumentException("Impossible to parse the object of the Ingestion Pipeline.");
        }
        return null;
    }
}

