/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts;

import com.lmax.disruptor.BatchEventProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.entity.alerts.AlertActionStatus;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.alerts.AlertUtil;
import org.openmetadata.service.alerts.AlertsActionPublisher;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertsPublisherManager {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsPublisherManager.class);
    private static CollectionDAO daoCollection;
    private static AlertsPublisherManager INSTANCE;
    private static volatile boolean INITIALIZED;
    private static final ConcurrentHashMap<UUID, Map<UUID, AlertsActionPublisher>> alertPublisherMap;

    public static void initialize(CollectionDAO dao) {
        if (!INITIALIZED) {
            daoCollection = dao;
            INSTANCE = new AlertsPublisherManager();
            INITIALIZED = true;
        } else {
            INITIALIZED = false;
            LOG.info("Email Util is already initialized");
        }
    }

    public static AlertsPublisherManager getInstance() {
        return INSTANCE;
    }

    public void addAlertActionPublishers(Alert alert) throws IOException {
        EntityRepository alertActionEntityRepository = Entity.getEntityRepository("alertAction");
        for (EntityReference alertActionRef : alert.getAlertActions()) {
            AlertAction action = (AlertAction)alertActionEntityRepository.get(null, alertActionRef.getId(), alertActionEntityRepository.getFields("*"));
            this.addAlertActionPublisher(alert, action);
        }
    }

    public AlertActionStatus getStatus(UUID alertId, UUID actionID) {
        AlertsActionPublisher pub;
        Map<UUID, AlertsActionPublisher> alertsActionPublisherMap = alertPublisherMap.get(alertId);
        if (alertsActionPublisherMap != null && (pub = alertsActionPublisherMap.get(actionID)) != null) {
            return pub.getAlertAction().getStatusDetails();
        }
        return null;
    }

    public void addAlertActionPublisher(Alert alert, AlertAction alertAction) {
        if (alertAction.getAlertActionType() == AlertAction.AlertActionType.ACTIVITY_FEED) {
            LOG.info("Activity Feed Alert Action cannot be created.");
            return;
        }
        AlertsActionPublisher publisher = AlertUtil.getAlertPublisher(alert, alertAction, daoCollection);
        if (Boolean.TRUE.equals(alertAction.getEnabled())) {
            BatchEventProcessor<EventPubSub.ChangeEventHolder> processor = EventPubSub.addEventHandler(publisher);
            publisher.setProcessor(processor);
            LOG.info("Alert publisher started for {}", (Object)alert.getName());
        } else {
            AlertActionStatus status = new AlertActionStatus().withStatus(AlertActionStatus.Status.DISABLED).withTimestamp(Long.valueOf(System.currentTimeMillis())).withFailureDetails(null);
            alertAction.setStatusDetails(status);
        }
        HashMap<UUID, AlertsActionPublisher> alertsActionPublisherMap = alertPublisherMap.get(alert.getId()) == null ? new HashMap<UUID, AlertsActionPublisher>() : alertPublisherMap.get(alert.getId());
        alertsActionPublisherMap.put(alertAction.getId(), publisher);
        alertPublisherMap.put(alert.getId(), alertsActionPublisherMap);
    }

    public void updateAlertActionPublishers(Alert alert) {
        this.deleteAlertAllPublishers(alert.getId());
        this.addAlertActionPublishers(alert);
    }

    public void updateAllAlertUsingAlertAction(AlertAction alertAction) {
        List<AlertsActionPublisher> publishers = this.getAlertPublisherFromAlertAction(alertAction.getId());
        if (publishers.size() != 0) {
            for (AlertsActionPublisher publisher : publishers) {
                Alert alert = publisher.getAlert();
                AlertAction action = publisher.getAlertAction();
                this.deleteAlertAllPublishers(alert.getId());
                if (action.getId().equals(alertAction.getId())) {
                    this.addAlertActionPublisher(alert, alertAction);
                    continue;
                }
                this.addAlertActionPublisher(alert, action);
            }
        }
    }

    public List<AlertsActionPublisher> getAlertPublisherFromAlertAction(UUID alertActionId) {
        ArrayList<AlertsActionPublisher> publisherManagers = new ArrayList<AlertsActionPublisher>();
        for (Map.Entry<UUID, Map<UUID, AlertsActionPublisher>> alertValues : alertPublisherMap.entrySet()) {
            if (!alertValues.getValue().containsKey(alertActionId)) continue;
            publisherManagers.add(alertValues.getValue().get(alertActionId));
        }
        return publisherManagers;
    }

    public void deleteAlertActionFromAllAlertPublisher(AlertAction alertAction) {
        List<AlertsActionPublisher> publishers = this.getAlertPublisherFromAlertAction(alertAction.getId());
        if (publishers.size() != 0) {
            for (AlertsActionPublisher alertsActionPublisher : publishers) {
                if (alertsActionPublisher == null) continue;
                this.deleteProcessorFromPubSub(alertsActionPublisher);
                UUID alertId = alertsActionPublisher.getAlert().getId();
                Map<UUID, AlertsActionPublisher> alertActionPublishersMap = alertPublisherMap.get(alertId);
                alertActionPublishersMap.remove(alertAction.getId());
                alertPublisherMap.put(alertId, alertActionPublishersMap);
            }
        }
    }

    public void deleteProcessorFromPubSub(AlertsActionPublisher publisher) throws InterruptedException {
        BatchEventProcessor<EventPubSub.ChangeEventHolder> processor = publisher.getProcessor();
        if (processor != null) {
            processor.halt();
            publisher.awaitShutdown();
            EventPubSub.removeProcessor(publisher.getProcessor());
            LOG.info("Alert publisher deleted for {}", (Object)publisher.getAlert().getName());
        }
    }

    public void deleteAlertAllPublishers(UUID alertId) throws InterruptedException {
        Map<UUID, AlertsActionPublisher> alertPublishers = alertPublisherMap.get(alertId);
        if (alertPublishers != null) {
            for (AlertsActionPublisher publisher : alertPublishers.values()) {
                this.deleteProcessorFromPubSub(publisher);
            }
            alertPublisherMap.remove(alertId);
        }
    }

    static {
        INITIALIZED = false;
        alertPublisherMap = new ConcurrentHashMap();
    }
}

