/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts.generic;

import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.alerts.AlertsActionPublisher;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericWebhookPublisher
extends AlertsActionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(GenericWebhookPublisher.class);
    private final Client client;
    private final Webhook webhook;

    public GenericWebhookPublisher(Alert alert, AlertAction alertAction) {
        super(alert, alertAction);
        if (alertAction.getAlertActionType() != AlertAction.AlertActionType.GENERIC_WEBHOOK) {
            throw new IllegalArgumentException("GenericWebhook Alert Invoked with Illegal Type and Settings.");
        }
        this.webhook = JsonUtils.convertValue(alertAction.getAlertActionConfig(), Webhook.class);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)alertAction.getTimeout().intValue(), TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)alertAction.getReadTimeout().intValue(), TimeUnit.SECONDS);
        this.client = clientBuilder.build();
    }

    @Override
    public void onStartDelegate() {
        LOG.info("Generic Webhook Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private Invocation.Builder getTarget() {
        Map<String, String> authHeaders = SecurityUtil.authHeaders("admin@open-metadata.org");
        return SecurityUtil.addHeaders(this.client.target(this.webhook.getEndpoint()), authHeaders);
    }

    @Override
    public void sendAlert(EventResource.ChangeEventList list) throws EventPublisherException {
        long attemptTime = System.currentTimeMillis();
        try {
            Response response;
            String json = JsonUtils.pojoToJson(list);
            if (this.webhook.getSecretKey() != null && !this.webhook.getSecretKey().isEmpty()) {
                String hmac = "sha256=" + CommonUtil.calculateHMAC((String)this.webhook.getSecretKey(), (String)json);
                response = this.getTarget().header("X-OM-Signature", (Object)hmac).post(Entity.json((Object)json));
            } else {
                response = this.getTarget().post(Entity.json((Object)json));
            }
            LOG.debug("GenericWebhook {}:{}:{} received response {}", new Object[]{this.alert.getName(), this.alertAction.getStatusDetails().getStatus(), this.batch.size(), response.getStatusInfo()});
            if (response.getStatus() >= 300 && response.getStatus() < 400) {
                this.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
            } else if (response.getStatus() >= 300 && response.getStatus() < 600) {
                this.setNextBackOff();
                this.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                Thread.sleep(this.currentBackoffTime);
            } else if (response.getStatus() == 200) {
                this.setSuccessStatus(System.currentTimeMillis());
            }
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause.getClass() == UnknownHostException.class) {
                LOG.warn("Invalid webhook {} endpoint {}", (Object)this.webhook.getName(), (Object)this.webhook.getEndpoint());
                this.setErrorStatus(attemptTime, 400, "UnknownHostException");
            }
            LOG.debug("Exception occurred while publishing webhook", (Throwable)ex);
        }
    }
}

