/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class TagIndex
implements ElasticSearchIndex {
    final Tag tag;

    public TagIndex(Tag tag) {
        this.tag = tag;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.tag);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.tag.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.tag.getName()).weight(10).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "tag");
        return doc;
    }
}

