/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class TeamIndex
implements ElasticSearchIndex {
    final Team team;
    final List<String> excludeFields = List.of("owns", "changeDescription", "roles", "inheritedRoles");

    public TeamIndex(Team team) {
        this.team = team;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.team);
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.team.getName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.team.getDisplayName()).weight(10).build());
        if (this.team.getDisplayName() == null) {
            doc.put("displayName", this.team.getName());
        }
        doc.put("suggest", suggest);
        doc.put("entityType", "team");
        return doc;
    }
}

