/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.util.JsonUtils;

public class TopicIndex
implements ElasticSearchIndex {
    final List<String> excludeTopicFields = List.of("sampleData", "changeDescription", "messageSchema");
    final Topic topic;

    public TopicIndex(Topic topic) {
        this.topic = topic;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.topic);
        ArrayList<TagLabel> tags = new ArrayList<TagLabel>();
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> serviceSuggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.topic.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.topic.getName()).weight(10).build());
        serviceSuggest.add(ElasticSearchSuggest.builder().input(this.topic.getService().getName()).weight(5).build());
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeTopicFields);
        if (this.topic.getTags() != null) {
            tags.addAll(this.topic.getTags());
        }
        ParseTags parseTags = new ParseTags(tags);
        doc.put("displayName", this.topic.getDisplayName() != null ? this.topic.getDisplayName() : this.topic.getName());
        doc.put("tags", parseTags.tags);
        doc.put("tier", parseTags.tierTag);
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.topic.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "topic");
        doc.put("serviceType", this.topic.getServiceType());
        doc.put("schemaText", this.topic.getMessageSchema() != null ? this.topic.getMessageSchema().getSchemaText() : null);
        doc.put("schemaType", this.topic.getMessageSchema() != null ? this.topic.getMessageSchema().getSchemaType() : null);
        return doc;
    }
}

