/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class AuditLogger {
    private static final Marker AUDIT_MARKER = MarkerFactory.getMarker((String)"AUDIT");
    private final Logger logger;

    private AuditLogger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public static AuditLogger getLogger(Class<?> clazz) {
        return new AuditLogger(clazz);
    }

    public void log(String message) {
        this.logger.error(AUDIT_MARKER, message);
    }

    public void log(String format, Object ... arguments) {
        this.logger.error(AUDIT_MARKER, format, arguments);
    }
}

