/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.exception;

import io.dropwizard.jersey.errors.ErrorMessage;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.openmetadata.service.exception.BadRequestException;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.IngestionPipelineDeploymentException;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.exception.WebServiceException;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.AuthorizationException;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogGenericExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogGenericExceptionMapper.class);

    public Response toResponse(Throwable ex) {
        LOG.debug(ex.getMessage());
        if (ex instanceof ProcessingException || ex instanceof IllegalArgumentException || ex instanceof javax.ws.rs.BadRequestException) {
            Response response = BadRequestException.of().getResponse();
            return Response.fromResponse((Response)response).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(response.getStatus(), ex.getLocalizedMessage())).build();
        }
        if (ex instanceof UnableToExecuteStatementException) {
            if (ex.getCause() instanceof SQLIntegrityConstraintViolationException || ex.getCause() instanceof PSQLException && ex.getCause().getMessage().contains("duplicate")) {
                return Response.status((Response.Status)Response.Status.CONFLICT).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(Response.Status.CONFLICT.getStatusCode(), "Entity already exists")).build();
            }
        } else {
            if (ex instanceof EntityNotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(Response.Status.NOT_FOUND.getStatusCode(), ex.getMessage())).build();
            }
            if (ex instanceof IngestionPipelineDeploymentException) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), ex.getMessage())).build();
            }
            if (ex instanceof AuthenticationException) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(Response.Status.UNAUTHORIZED.getStatusCode(), ex.getMessage())).build();
            }
            if (ex instanceof AuthorizationException) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(Response.Status.FORBIDDEN.getStatusCode(), ex.getMessage())).build();
            }
            if (ex instanceof WebServiceException) {
                Response response = ((WebServiceException)ex).getResponse();
                Response.Status.Family family = response.getStatusInfo().getFamily();
                if (family.equals((Object)Response.Status.Family.REDIRECTION)) {
                    return response;
                }
                if (family.equals((Object)Response.Status.Family.SERVER_ERROR)) {
                    this.throwException(ex);
                }
                return Response.fromResponse((Response)response).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(response.getStatus(), ex.getLocalizedMessage())).build();
            }
        }
        LOG.info("exception ", ex);
        this.logUnhandledException(ex);
        return new UnhandledServerException(ex.getMessage()).getResponse();
    }

    private void logUnhandledException(Throwable ex) {
        Object errMessage = String.format("Got exception: [%s] / message [%s]", ex.getClass().getSimpleName(), ex.getMessage());
        StackTraceElement elem = this.findFirstResourceCallFromCallStack(ex.getStackTrace());
        String resourceClassName = null;
        if (elem != null) {
            errMessage = (String)errMessage + String.format(" / related resource location: [%s.%s](%s:%d)", elem.getClassName(), elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
            resourceClassName = elem.getClassName();
        }
        Logger log = this.getEffectiveLogger(resourceClassName);
        log.error((String)errMessage, ex);
    }

    protected void throwException(Throwable exception) {
        long id = ThreadLocalRandom.current().nextLong();
        this.throwException(id, exception);
    }

    protected void throwException(long id, Throwable exception) {
        LOG.error(this.formatLogMessage(id), exception);
    }

    protected String formatLogMessage(long id) {
        return String.format("Error handling a request: %016x", id);
    }

    private StackTraceElement findFirstResourceCallFromCallStack(StackTraceElement[] stackTrace) {
        for (StackTraceElement stackTraceElement : stackTrace) {
            try {
                Class<?> aClass = Class.forName(stackTraceElement.getClassName());
                Path pathAnnotation = aClass.getAnnotation(Path.class);
                if (pathAnnotation == null) continue;
                return stackTraceElement;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private Logger getEffectiveLogger(String resourceClassName) {
        Logger log = LOG;
        if (resourceClassName != null) {
            log = LoggerFactory.getLogger((String)resourceClassName);
        }
        return log;
    }
}

