/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.exception;

import io.dropwizard.jersey.errors.ErrorMessage;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class WebServiceException
extends RuntimeException {
    private final transient Response response;

    protected WebServiceException(Response.Status status, String msg) {
        super(msg);
        this.response = Response.status((Response.Status)status).entity((Object)WebServiceException.convertToErrorResponseMessage(msg)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected WebServiceException(int status, String msg) {
        super(msg);
        this.response = Response.status((int)status).entity((Object)new ErrorMessage(status, msg)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected WebServiceException(Response.Status status, String msg, Throwable cause) {
        super(msg, cause);
        this.response = Response.status((Response.Status)status).entity((Object)WebServiceException.convertToErrorResponseMessage(msg)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static ErrorResponse convertToErrorResponseMessage(String msg) {
        return new ErrorResponse(msg);
    }

    public Response getResponse() {
        return this.response;
    }

    private static class ErrorResponse {
        private final String responseMessage;

        ErrorResponse(String responseMessage) {
            this.responseMessage = responseMessage;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }
    }
}

