/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.List;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;

public abstract class ServiceEntityRepository<T extends ServiceEntityInterface, S extends ServiceConnectionEntityInterface>
extends EntityRepository<T> {
    private static final String UPDATE_FIELDS = "owner,tags";
    private static final String PATCH_FIELDS = "owner,tags";
    private final Class<S> serviceConnectionClass;
    private final ServiceType serviceType;

    protected ServiceEntityRepository(String collectionPath, String service, CollectionDAO dao, EntityDAO<T> entityDAO, Class<S> serviceConnectionClass, ServiceType serviceType) {
        this(collectionPath, service, dao, entityDAO, serviceConnectionClass, "owner,tags", serviceType);
    }

    protected ServiceEntityRepository(String collectionPath, String service, CollectionDAO dao, EntityDAO<T> entityDAO, Class<S> serviceConnectionClass, String updatedFields, ServiceType serviceType) {
        super(collectionPath, service, entityDAO.getEntityClass(), entityDAO, dao, "owner,tags", updatedFields);
        this.serviceConnectionClass = serviceConnectionClass;
        this.serviceType = serviceType;
    }

    @Override
    public T setFields(T entity, EntityUtil.Fields fields) throws IOException {
        entity.setPipelines(fields.contains("pipelines") ? this.getIngestionPipelines(entity) : null);
        return entity;
    }

    @Override
    public void prepare(T service) {
        service.getConnection().setConfig(SecretsManagerFactory.getSecretsManager().encryptOrDecryptServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), service.getName(), this.serviceType, true));
    }

    @Override
    public void storeEntity(T service, boolean update) throws IOException {
        EntityReference owner = service.getOwner();
        List tags = service.getTags();
        service.withOwner(null).withHref(null).setTags(null);
        this.store(service, update);
        service.withOwner(owner).setTags(tags);
    }

    @Override
    public void storeRelationships(T service) {
        this.storeOwner(service, service.getOwner());
        this.applyTags(service);
    }

    @Override
    public ServiceUpdater getUpdater(T original, T updated, EntityRepository.Operation operation) {
        return new ServiceUpdater(this, original, updated, operation);
    }

    public Class<S> getServiceConnectionClass() {
        return this.serviceConnectionClass;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public static class ServiceUpdater
    extends EntityRepository.EntityUpdater {
        final /* synthetic */ ServiceEntityRepository this$0;

        public ServiceUpdater(T original, T updated, EntityRepository.Operation operation) {
            this.this$0 = this$0;
            super((EntityRepository)this$0, original, updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateConnection();
        }

        private void updateConnection() throws IOException {
            ServiceConnectionEntityInterface origConn = ((ServiceEntityInterface)this.original).getConnection();
            ServiceConnectionEntityInterface updatedConn = ((ServiceEntityInterface)this.updated).getConnection();
            String origJson = JsonUtils.pojoToJson(origConn);
            String updatedJson = JsonUtils.pojoToJson(updatedConn);
            ServiceConnectionEntityInterface decryptedOrigConn = (ServiceConnectionEntityInterface)JsonUtils.readValue(origJson, this.this$0.serviceConnectionClass);
            ServiceConnectionEntityInterface decryptedUpdatedConn = (ServiceConnectionEntityInterface)JsonUtils.readValue(updatedJson, this.this$0.serviceConnectionClass);
            SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
            decryptedOrigConn.setConfig(secretsManager.encryptOrDecryptServiceConnectionConfig(decryptedOrigConn.getConfig(), ((ServiceEntityInterface)this.original).getServiceType().value(), ((ServiceEntityInterface)this.original).getName(), this.this$0.serviceType, false));
            decryptedUpdatedConn.setConfig(secretsManager.encryptOrDecryptServiceConnectionConfig(decryptedUpdatedConn.getConfig(), ((ServiceEntityInterface)this.updated).getServiceType().value(), ((ServiceEntityInterface)this.updated).getName(), this.this$0.serviceType, false));
            if (!EntityUtil.objectMatch.test(decryptedOrigConn, decryptedUpdatedConn)) {
                this.recordChange("connection", "old-encrypted-value", "new-encrypted-value", true);
            }
        }
    }
}

