/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.monitoring;

import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.events.AbstractEventPublisher;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.monitoring.EventMonitor;
import org.openmetadata.service.monitoring.EventMonitorConfiguration;
import org.openmetadata.service.resources.events.EventResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMonitorPublisher
extends AbstractEventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(EventMonitorPublisher.class);
    private final EventMonitor eventMonitor;

    public EventMonitorPublisher(EventMonitorConfiguration config, EventMonitor eventMonitor) {
        super(config.getBatchSize());
        this.eventMonitor = eventMonitor;
    }

    @Override
    public void publish(EventResource.ChangeEventList events) throws EventPublisherException {
        for (ChangeEvent event : events.getData()) {
            String entityType = event.getEntityType();
            if (!"ingestionPipeline".equals(entityType)) continue;
            this.eventMonitor.pushMetric(event);
        }
    }

    public void onStart() {
        LOG.info("Event Monitor Publisher Started");
    }

    public void onShutdown() {
        this.eventMonitor.close();
        LOG.info("Event Monitor Publisher Closed");
    }
}

