/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.alerts;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.events.CreateAlertAction;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.alerts.AlertsPublisherManager;
import org.openmetadata.service.jdbi3.AlertActionRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.policies.PolicyResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/alertAction")
@Api(value="Alerts collection", tags={"Alerts collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="alertAction", order=7)
public class AlertActionResource
extends EntityResource<AlertAction, AlertActionRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(AlertActionResource.class);
    public static final String COLLECTION_PATH = "v1/alertAction/";
    public static final String FIELDS = "owner";

    @Override
    public AlertAction addHref(UriInfo uriInfo, AlertAction entity) {
        Entity.withHref(uriInfo, entity.getOwner());
        return entity;
    }

    public AlertActionResource(CollectionDAO dao, Authorizer authorizer) {
        super(AlertAction.class, new AlertActionRepository(dao), authorizer);
        AlertsPublisherManager.initialize(dao);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        this.initDefaultAlertActions();
    }

    private void initDefaultAlertActions() throws IOException {
        List<String> jsonDataFiles = EntityUtil.getJsonDataResources(".*json/data/alerts/alertsActionData.json$");
        if (jsonDataFiles.size() != 1) {
            LOG.warn("Invalid number of jsonDataFiles {}. Only one expected.", (Object)jsonDataFiles.size());
            return;
        }
        String jsonDataFile = jsonDataFiles.get(0);
        try {
            String json = CommonUtil.getResourceAsStream((ClassLoader)PolicyResource.class.getClassLoader(), (String)jsonDataFile);
            AlertAction alertActions = JsonUtils.readObjects(json, AlertAction.class).get(0);
            alertActions.setId(UUID.randomUUID());
            ((AlertActionRepository)this.dao).initializeEntity(alertActions);
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize the resource descriptors from file {}", (Object)jsonDataFile, (Object)e);
        }
    }

    @GET
    @Operation(operationId="listAlertActions", summary="List all alerts actions", tags={"alertAction"}, description="Get a list of all alert actions", responses={@ApiResponse(responseCode="200", description="List of alerts action subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertActionList.class))})})
    public ResultList<AlertAction> listAlertAction(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter alerts action by type", schema=@Schema(type="string", example="generic, slack, msteams")) @QueryParam(value="alertActionType") String typeParam, @Parameter(description="Limit the number alerts returned. (1 to 1000000, default = 10) ") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of alerts before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of alerts after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(Include.ALL).addQueryParam("alertActionType", typeParam);
        return this.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Valid
    @Operation(operationId="getAlertActionByID", summary="Get a alert alert action", tags={"alertAction"}, description="Get a alert action by given Id", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertAction.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public AlertAction getAlertActionById(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (AlertAction)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getAlertActionByFQN", summary="Get a alert action by name", tags={"alertAction"}, description="Get a alert action by name.", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertAction.class))}), @ApiResponse(responseCode="404", description="Alert Action for instance {id} is not found")})
    public AlertAction getAlertActionByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Name of the alert action", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (AlertAction)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllAlertVersion", summary="List alert versions", tags={"alertAction"}, description="Get a list of all the versions of a alert action identified by `id`", responses={@ApiResponse(responseCode="200", description="List of alert versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listAlertActionVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificAlertActionVersion", summary="Get a version of the alert action", tags={"alertAction"}, description="Get a version of the alert action by given `id`", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertAction.class))}), @ApiResponse(responseCode="404", description="Alert for instance {id} and version {version} is not found")})
    public AlertAction getAlertActionVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="alert version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (AlertAction)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createAlertAction", summary="Create a new alert Action", tags={"alertAction"}, description="Create a new Alert Action", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateAlertAction.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createAlertAction(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAlertAction create) throws IOException {
        this.generateRandomAlertActionName(create);
        AlertAction alertAction = this.getAlertAction(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, alertAction);
    }

    @POST
    @Path(value="/bulk")
    @Operation(operationId="bulkCreateAlertAction", summary="Create new alert Action with Bulk", tags={"alertAction"}, description="Create new alert Action with Bulk", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateAlertAction.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response bulkCreateAlertAction(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid List<CreateAlertAction> create) throws IOException {
        ArrayList<AlertAction> alert = new ArrayList<AlertAction>();
        for (CreateAlertAction createAlertAction : create) {
            this.generateRandomAlertActionName(createAlertAction);
            AlertAction alertAction = this.getAlertAction(createAlertAction, securityContext.getUserPrincipal().getName());
            Response resp = this.create(uriInfo, securityContext, alertAction);
            alert.add((AlertAction)resp.getEntity());
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity(alert).build();
    }

    @PUT
    @Operation(operationId="createOrUpdateAlertAction", summary="Updated an existing or create a new Alert Action", tags={"alertAction"}, description="Updated an existing or create a new alert Action", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateAlertAction.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response updateAlertAction(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAlertAction create) throws IOException {
        if (CommonUtil.nullOrEmpty((String)create.getName())) {
            throw new IllegalArgumentException("[name] must not be null.");
        }
        AlertAction alertAction = this.getAlertAction(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, alertAction);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchAlertAction", summary="Update a Alert Action", tags={"alertAction"}, description="Update an existing alert using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patchAlertAction(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Valid
    @Operation(operationId="deleteAlert", summary="Delete a Alert Action", tags={"alertAction"}, description="Get a alert action by given Id", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertAction.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public Response deleteAlertAction(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        Response response = this.delete(uriInfo, securityContext, id, false, true);
        AlertsPublisherManager.getInstance().deleteAlertActionFromAllAlertPublisher((AlertAction)response.getEntity());
        return response;
    }

    public AlertAction getAlertAction(CreateAlertAction create, String user) throws IOException {
        return this.copy(new AlertAction(), (CreateEntity)create, user).withEnabled(create.getEnabled()).withAlertActionType(create.getAlertActionType()).withBatchSize(create.getBatchSize()).withTimeout(create.getTimeout()).withReadTimeout(create.getReadTimeout()).withAlertActionConfig(create.getAlertActionConfig());
    }

    public void generateRandomAlertActionName(CreateAlertAction createRequest) {
        if (CommonUtil.nullOrEmpty((String)createRequest.getName())) {
            String name = String.format("%s_%s", createRequest.getAlertActionType().toString(), UUID.randomUUID());
            createRequest.setName(name);
            createRequest.setDisplayName(name);
        }
    }

    public static class AlertActionList
    extends ResultList<AlertAction> {
    }
}

