/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.elasticsearch;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.elasticsearch.client.RestHighLevelClient;
import org.openmetadata.schema.api.CreateEventPublisherJob;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.settings.EventPublisherJob;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexDefinition;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ElasticSearchClientUtils;
import org.openmetadata.service.util.ElasticSearchIndexUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/indexResource")
@Api(value="Elastic Search Collection", tags={"Elastic Search Collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="indexResource")
public class BuildSearchIndexResource {
    private static final Logger LOG = LoggerFactory.getLogger(BuildSearchIndexResource.class);
    public static final String ELASTIC_SEARCH_EXTENSION = "service.eventPublisher";
    public static final String ELASTIC_SEARCH_ENTITY_FQN_STREAM = "eventPublisher:ElasticSearch:STREAM";
    public static final String ELASTIC_SEARCH_ENTITY_FQN_BATCH = "eventPublisher:ElasticSearch:BATCH";
    private final CollectionDAO dao;
    private final Authorizer authorizer;
    private final UserRepository userRepository;
    private ElasticSearchIndexUtil elasticSearchIndexUtil;

    public BuildSearchIndexResource(CollectionDAO dao, Authorizer authorizer) {
        this.dao = dao;
        this.userRepository = new UserRepository(dao);
        this.authorizer = authorizer;
    }

    public void initialize(OpenMetadataApplicationConfig config) {
        if (config.getElasticSearchConfiguration() != null) {
            RestHighLevelClient client = ElasticSearchClientUtils.createElasticSearchClient(config.getElasticSearchConfiguration());
            ElasticSearchIndexDefinition elasticSearchIndexDefinition = new ElasticSearchIndexDefinition(client, this.dao);
            this.elasticSearchIndexUtil = new ElasticSearchIndexUtil(this.dao, client, elasticSearchIndexDefinition, config.getElasticSearchConfiguration().getSearchIndexMappingLanguage().value());
        }
    }

    @POST
    @Path(value="/reindex")
    @Operation(operationId="reindexEntities", summary="Reindex Entities", tags={"indexResource"}, description="Reindex Elastic Search Entities", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Response reindexAllEntities(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateEventPublisherJob createRequest) throws IOException {
        this.authorizer.authorizeAdmin(securityContext);
        User user = (User)this.userRepository.getByName(null, securityContext.getUserPrincipal().getName(), this.userRepository.getFields("id"));
        if (createRequest.getRunMode() == CreateEventPublisherJob.RunMode.BATCH) {
            return this.elasticSearchIndexUtil.startReindexingBatchMode(uriInfo, user.getId(), createRequest);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Run Mode").build();
    }

    @GET
    @Path(value="/reindex/status/{runMode}")
    @Operation(operationId="getReindexAllLastJobStatus", summary="Get Last Run Reindex All Job Status", tags={"indexResource"}, description="Reindex All job last status", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Response reindexAllJobLastStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="runMode") String runMode) throws IOException {
        String record;
        this.authorizer.authorizeAdmin(securityContext);
        if (runMode.equals(CreateEventPublisherJob.RunMode.BATCH.toString())) {
            record = this.dao.entityExtensionTimeSeriesDao().getLatestExtension(ELASTIC_SEARCH_ENTITY_FQN_BATCH, ELASTIC_SEARCH_EXTENSION);
        } else if (runMode.equals(CreateEventPublisherJob.RunMode.STREAM.toString())) {
            record = this.dao.entityExtensionTimeSeriesDao().getLatestExtension(ELASTIC_SEARCH_ENTITY_FQN_STREAM, ELASTIC_SEARCH_EXTENSION);
        } else {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Run Mode").build();
        }
        if (record != null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtils.readValue(record, EventPublisherJob.class)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No Last Run.").build();
    }
}

