/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Arrays;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.type.CollectionDescriptor;
import org.openmetadata.service.resources.CatalogResource;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.CollectionRegistry;

@Path(value="/v1/services")
@Api(value="Services collection", tags={"Services collection"})
@Produces(value={"application/json"})
@Collection(name="services")
public class ServiceResource {
    private static CatalogResource.CollectionList serviceList;

    public static CatalogResource.CollectionList getServiceList(UriInfo uriInfo) {
        if (serviceList == null) {
            CollectionDescriptor[] services = CollectionRegistry.getInstance().getCollectionForPath("/v1/services", uriInfo);
            serviceList = new CatalogResource.CollectionList(Arrays.asList(services));
        }
        return serviceList;
    }

    @GET
    @Operation(operationId="listServiceCollection", summary="List service collections", tags={"services"}, description="Get a list of resources under service collection.", responses={@ApiResponse(responseCode="200", description="List of serviceCollections", content={@Content(mediaType="application/json", schema=@Schema(implementation=CatalogResource.CollectionList.class))})})
    public CatalogResource.CollectionList getCollections(@Context UriInfo uriInfo) {
        return ServiceResource.getServiceList(uriInfo);
    }
}

