/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.storage;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreateStorageService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.StorageServiceRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/services/storageServices")
@Api(value="Storage service collection", tags={"Services -> Storage service collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="storageServices")
public class StorageServiceResource
extends EntityResource<StorageService, StorageServiceRepository> {
    public static final String COLLECTION_PATH = "v1/services/storageServices/";
    static final String FIELDS = "owner";

    @Override
    public StorageService addHref(UriInfo uriInfo, StorageService service) {
        service.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, service.getId()));
        Entity.withHref(uriInfo, service.getOwner());
        return service;
    }

    public StorageServiceResource(CollectionDAO dao, Authorizer authorizer) {
        super(StorageService.class, new StorageServiceRepository(dao), authorizer);
    }

    @GET
    @Operation(operationId="listStorageService", summary="List storage services", tags={"storageServices"}, description="Get a list of storage services. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of storage services", content={@Content(mediaType="application/json", schema=@Schema(implementation=StorageServiceList.class))})})
    public ResultList<StorageService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit number of services returned. (1 to 1000000, default 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getStorageServiceByID", summary="Get a storage service", tags={"storageServices"}, description="Get a storage service by `id`.", responses={@ApiResponse(responseCode="200", description="Storage service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=StorageService.class))}), @ApiResponse(responseCode="404", description="Storage service for instance {id} is not found")})
    public StorageService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (StorageService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getStorageServiceByFQN", summary="Get storage service by name", tags={"storageServices"}, description="Get a storage service by the service `name`.", responses={@ApiResponse(responseCode="200", description="Storage service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=StorageService.class))}), @ApiResponse(responseCode="404", description="Storage service for instance {id} is not found")})
    public StorageService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (StorageService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllStorageServiceVersion", summary="List storage service versions", tags={"storageServices"}, description="Get a list of all the versions of a storage service identified by `id`", responses={@ApiResponse(responseCode="200", description="List of storage service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="storage service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificStorageServiceVersion", summary="Get a version of the storage service", tags={"storageServices"}, description="Get a version of the storage service by given `id`", responses={@ApiResponse(responseCode="200", description="storage service", content={@Content(mediaType="application/json", schema=@Schema(implementation=StorageService.class))}), @ApiResponse(responseCode="404", description="Storage service for instance {id} and version {version} is not found")})
    public StorageService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="storage service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="storage service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (StorageService)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createStorageService", summary="Create storage service", tags={"storageServices"}, description="Create a new storage service.", responses={@ApiResponse(responseCode="200", description="Storage service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=StorageService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateStorageService create) throws IOException {
        StorageService service = this.getService(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, service);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateStorageService", summary="Update storage service", tags={"storageServices"}, description="Update an existing storage service identified by `id`.", responses={@ApiResponse(responseCode="200", description="Storage service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=StorageService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateStorageService update) throws IOException {
        StorageService service = this.getService(update, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, service);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteStorageService", summary="Delete a storage service", tags={"storageServices"}, description="Delete a storage services. If storages (and tables) belong the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="StorageService service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the storage service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted StorageService.", tags={"storageServices"}, description="Restore a soft deleted StorageService.", responses={@ApiResponse(responseCode="200", description="Successfully restored the StorageService ", content={@Content(mediaType="application/json", schema=@Schema(implementation=StorageService.class))})})
    public Response restoreTable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private StorageService getService(CreateStorageService create, String user) throws IOException {
        return this.copy(new StorageService(), (CreateEntity)create, user).withServiceType(create.getServiceType());
    }

    public static class StorageServiceList
    extends ResultList<StorageService> {
    }
}

