/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.secrets.ExternalSecretsManager;

public class InMemorySecretsManager
extends ExternalSecretsManager {
    private static InMemorySecretsManager INSTANCE;
    private final Map<String, String> secretsMap = new HashMap<String, String>();

    protected InMemorySecretsManager(String clusterPrefix) {
        super(SecretsManagerProvider.IN_MEMORY, clusterPrefix, 0L);
    }

    public static InMemorySecretsManager getInstance(String clusterPrefix) {
        if (INSTANCE == null) {
            INSTANCE = new InMemorySecretsManager(clusterPrefix);
        }
        return INSTANCE;
    }

    @Override
    void storeSecret(String secretName, String secretValue) {
        this.secretsMap.put(secretName, secretValue);
    }

    @Override
    void updateSecret(String secretName, String secretValue) {
        this.storeSecret(secretName, secretValue);
    }

    @Override
    String getSecret(String secretName) {
        String value = this.secretsMap.getOrDefault(secretName, null);
        if (value == null) {
            throw new SecretsManagerException(String.format("Key [%s] not found in in-memory secrets manager", secretName));
        }
        return value;
    }

    public Map<String, String> getSecretsMap() {
        return this.secretsMap;
    }
}

