/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.util.AuthenticationMechanismBuilder;
import org.openmetadata.service.util.IngestionPipelineBuilder;
import org.openmetadata.service.util.JsonUtils;

public abstract class SecretsManager {
    private final String clusterPrefix;
    private final SecretsManagerProvider secretsManagerProvider;
    private Fernet fernet;
    private static final Set<Class<?>> DO_NOT_ENCRYPT_CLASSES = Set.of(OpenMetadataJWTClientConfig.class);

    protected SecretsManager(SecretsManagerProvider secretsManagerProvider, String clusterPrefix) {
        this.secretsManagerProvider = secretsManagerProvider;
        this.clusterPrefix = clusterPrefix;
        this.fernet = Fernet.getInstance();
    }

    public Object encryptOrDecryptServiceConnectionConfig(Object connectionConfig, String connectionType, String connectionName, ServiceType serviceType, boolean encrypt) {
        try {
            Class<?> clazz = this.createConnectionConfigClass(connectionType, this.extractConnectionPackageName(serviceType));
            Object newConnectionConfig = JsonUtils.convertValue(connectionConfig, clazz);
            return this.encryptOrDecryptPasswordFields(newConnectionConfig, this.buildSecretId(true, serviceType.value(), connectionName), encrypt);
        }
        catch (Exception e) {
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to encrypt connection instance of %s", connectionType));
        }
    }

    public AuthenticationMechanism encryptOrDecryptAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism, boolean encrypt) {
        if (authenticationMechanism != null) {
            authenticationMechanism = AuthenticationMechanismBuilder.build(authenticationMechanism);
            try {
                return (AuthenticationMechanism)this.encryptOrDecryptPasswordFields(authenticationMechanism, this.buildSecretId(true, "bot", name), encrypt);
            }
            catch (Exception e) {
                throw InvalidServiceConnectionException.byMessage(name, String.format("Failed to encrypt user bot instance [%s]", name));
            }
        }
        return null;
    }

    public IngestionPipeline encryptOrDecryptIngestionPipeline(IngestionPipeline ingestionPipeline, boolean encrypt) {
        IngestionPipeline ingestion = IngestionPipelineBuilder.build(ingestionPipeline);
        try {
            return (IngestionPipeline)this.encryptOrDecryptPasswordFields(ingestion, this.buildSecretId(true, "pipeline", ingestion.getName()), encrypt);
        }
        catch (Exception e) {
            throw InvalidServiceConnectionException.byMessage(ingestion.getName(), String.format("Failed to encrypt ingestion pipeline instance [%s]", ingestion.getName()));
        }
    }

    private Object encryptOrDecryptPasswordFields(Object targetObject, String name, boolean encrypt) {
        if (encrypt) {
            this.encryptPasswordFields(targetObject, name);
        } else {
            this.decryptPasswordFields(targetObject);
        }
        return targetObject;
    }

    private void encryptPasswordFields(Object toEncryptObject, String secretId) {
        if (!DO_NOT_ENCRYPT_CLASSES.contains(toEncryptObject.getClass())) {
            Arrays.stream(toEncryptObject.getClass().getMethods()).filter(this::isGetMethodOfObject).forEach(method -> {
                Object obj = this.getObjectFromMethod((Method)method, toEncryptObject);
                String fieldName = method.getName().replaceFirst("get", "");
                if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                    this.encryptPasswordFields(obj, this.buildSecretId(false, secretId, fieldName.toLowerCase(Locale.ROOT)));
                } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                    String newFieldValue = this.storeValue(fieldName, this.decryptFernetIfApplies((String)obj), secretId);
                    Method toSet = this.getToSetMethod(toEncryptObject, obj, fieldName);
                    this.setValueInMethod(toEncryptObject, Fernet.isTokenized(newFieldValue) ? newFieldValue : this.fernet.encrypt(newFieldValue), toSet);
                }
            });
        }
    }

    private String decryptFernetIfApplies(String value) {
        return Fernet.isTokenized(value) ? this.fernet.decrypt(value) : value;
    }

    private void decryptPasswordFields(Object toDecryptObject) {
        Arrays.stream(toDecryptObject.getClass().getMethods()).filter(this::isGetMethodOfObject).forEach(method -> {
            Object obj = this.getObjectFromMethod((Method)method, toDecryptObject);
            String fieldName = method.getName().replaceFirst("get", "");
            if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                this.decryptPasswordFields(obj);
            } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                String fieldValue = (String)obj;
                Method toSet = this.getToSetMethod(toDecryptObject, obj, fieldName);
                this.setValueInMethod(toDecryptObject, Fernet.isTokenized(fieldValue) ? this.fernet.decrypt(fieldValue) : fieldValue, toSet);
            }
        });
    }

    protected abstract String storeValue(String var1, String var2, String var3);

    private void setValueInMethod(Object toEncryptObject, String fieldValue, Method toSet) {
        try {
            toSet.invoke(toEncryptObject, fieldValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SecretsManagerException(e.getMessage());
        }
    }

    private Method getToSetMethod(Object toEncryptObject, Object obj, String fieldName) {
        try {
            return toEncryptObject.getClass().getMethod("set" + fieldName, obj.getClass());
        }
        catch (NoSuchMethodException e) {
            throw new SecretsManagerException(e.getMessage());
        }
    }

    private Object getObjectFromMethod(Method method, Object toEncryptObject) {
        Object obj;
        try {
            obj = method.invoke(toEncryptObject, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SecretsManagerException(e.getMessage());
        }
        return obj;
    }

    private boolean isGetMethodOfObject(Method method) {
        return method.getName().startsWith("get") && !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().isPrimitive();
    }

    protected String getSecretSeparator() {
        return "/";
    }

    protected boolean startsWithSeparator() {
        return true;
    }

    protected String buildSecretId(boolean addClusterPrefix, String ... secretIdValues) {
        StringBuilder format = new StringBuilder();
        if (addClusterPrefix) {
            format.append(this.startsWithSeparator() ? this.getSecretSeparator() : "");
            format.append(this.clusterPrefix);
        } else {
            format.append("%s");
        }
        Arrays.stream(secretIdValues).skip(addClusterPrefix ? 0L : 1L).forEach(secretIdValue -> {
            if (Objects.isNull(secretIdValue)) {
                throw new SecretsManagerException("Cannot build a secret id with null values.");
            }
            format.append(this.getSecretSeparator());
            format.append("%s");
        });
        return String.format(format.toString(), secretIdValues).toLowerCase();
    }

    protected Class<?> createConnectionConfigClass(String connectionType, String connectionPackage) throws ClassNotFoundException {
        String clazzName = "org.openmetadata.schema.services.connections." + connectionPackage + "." + connectionType + "Connection";
        return Class.forName(clazzName);
    }

    protected String extractConnectionPackageName(ServiceType serviceType) {
        return serviceType.value().toLowerCase(Locale.ROOT);
    }

    @VisibleForTesting
    void setFernet(Fernet fernet) {
        this.fernet = fernet;
    }

    public String getClusterPrefix() {
        return this.clusterPrefix;
    }

    public SecretsManagerProvider getSecretsManagerProvider() {
        return this.secretsManagerProvider;
    }
}

