/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.util.JsonUtils;

public class JsonPatchUtils {
    private JsonPatchUtils() {
    }

    public static List<MetadataOperation> getMetadataOperations(JsonPatch jsonPatch) {
        return jsonPatch.toJsonArray().stream().map(JsonPatchUtils::getMetadataOperation).distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static MetadataOperation getMetadataOperation(Object jsonPatchObject) {
        String[] fields;
        Map<String, Object> jsonPatchMap = JsonUtils.getMap(jsonPatchObject);
        String path = jsonPatchMap.get("path").toString();
        for (String field : fields = ResourceRegistry.getEditableFields()) {
            if (!path.contains(field)) continue;
            return ResourceRegistry.getEditOperation(field);
        }
        return null;
    }
}

