/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Response;
import org.openmetadata.api.configuration.airflow.TaskNotificationConfiguration;
import org.openmetadata.api.configuration.airflow.TestResultNotificationConfiguration;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.EmailUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationHandler.class);
    private final CollectionDAO dao;
    private final ObjectMapper mapper;
    private final ExecutorService threadScheduler;

    public NotificationHandler(CollectionDAO dao) {
        this.dao = dao;
        this.mapper = new ObjectMapper();
        this.threadScheduler = Executors.newFixedThreadPool(1);
    }

    public void processNotifications(ContainerResponseContext responseContext) {
        this.threadScheduler.submit(() -> {
            try {
                this.handleNotifications(responseContext);
            }
            catch (JsonProcessingException e) {
                LOG.error("[NotificationHandler] Failed to use mapper in converting to Json", (Throwable)e);
            }
        });
    }

    private void handleNotifications(ContainerResponseContext responseContext) throws JsonProcessingException {
        int responseCode = responseContext.getStatus();
        if (responseCode == Response.Status.CREATED.getStatusCode() && responseContext.getEntity() != null && responseContext.getEntity().getClass().equals(Thread.class)) {
            Thread thread = (Thread)responseContext.getEntity();
            switch (thread.getType()) {
                case Task: {
                    this.handleTaskNotification(thread);
                    break;
                }
                case Conversation: {
                    this.handleConversationNotification(thread);
                    break;
                }
                case Announcement: {
                    this.handleAnnouncementNotification(thread);
                }
            }
        } else if (responseContext.getEntity() != null && responseContext.getEntity().getClass().equals(ChangeEvent.class)) {
            ChangeEvent changeEvent = (ChangeEvent)responseContext.getEntity();
            this.handleTestResultEmailNotification(changeEvent);
        }
    }

    private void handleTaskNotification(Thread thread) throws JsonProcessingException {
        String jsonThread = this.mapper.writeValueAsString((Object)thread);
        if (thread.getPostsCount() == 0) {
            List assignees = thread.getTask().getAssignees();
            HashSet<UUID> receiversList = new HashSet<UUID>();
            assignees.forEach(e -> {
                if ("user".equals(e.getType())) {
                    receiversList.add(e.getId());
                } else if ("team".equals(e.getType())) {
                    List<CollectionDAO.EntityRelationshipRecord> records = this.dao.relationshipDAO().findTo(e.getId().toString(), "team", Relationship.HAS.ordinal(), "user");
                    records.forEach(eRecord -> receiversList.add(eRecord.getId()));
                }
            });
            WebSocketManager.getInstance().sendToManyWithUUID(receiversList, "taskChannel", jsonThread);
            TaskNotificationConfiguration taskSetting = SettingsCache.getInstance().getSetting(SettingsType.TASK_NOTIFICATION_CONFIGURATION, TaskNotificationConfiguration.class);
            if (taskSetting.getEnabled().booleanValue()) {
                this.handleEmailNotifications(receiversList, thread);
            }
        }
    }

    private void handleAnnouncementNotification(Thread thread) throws JsonProcessingException {
        String jsonThread = this.mapper.writeValueAsString((Object)thread);
        AnnouncementDetails announcementDetails = thread.getAnnouncement();
        Long currentTimestamp = Instant.now().getEpochSecond();
        if (announcementDetails.getStartTime() <= currentTimestamp && currentTimestamp <= announcementDetails.getEndTime()) {
            WebSocketManager.getInstance().broadCastMessageToAll("announcementChannel", jsonThread);
        }
    }

    private void handleConversationNotification(Thread thread) throws JsonProcessingException {
        List<MessageParser.EntityLink> mentions;
        String jsonThread = this.mapper.writeValueAsString((Object)thread);
        WebSocketManager.getInstance().broadCastMessageToAll("activityFeed", jsonThread);
        if (thread.getPostsCount() == 0) {
            mentions = MessageParser.getEntityLinks(thread.getMessage());
        } else {
            Post latestPost = (Post)thread.getPosts().get(thread.getPostsCount() - 1);
            mentions = MessageParser.getEntityLinks(latestPost.getMessage());
        }
        mentions.forEach(entityLink -> {
            String fqn = entityLink.getEntityFQN();
            if ("user".equals(entityLink.getEntityType())) {
                User user = (User)this.dao.userDAO().findEntityByName(fqn);
                WebSocketManager.getInstance().sendToOne(user.getId(), "mentionChannel", jsonThread);
            } else if ("team".equals(entityLink.getEntityType())) {
                Team team = (Team)this.dao.teamDAO().findEntityByName(fqn);
                List<CollectionDAO.EntityRelationshipRecord> records = this.dao.relationshipDAO().findTo(team.getId().toString(), "team", Relationship.HAS.ordinal(), "user");
                WebSocketManager.getInstance().sendToManyWithString(records, "mentionChannel", jsonThread);
            }
        });
    }

    private void handleEmailNotifications(HashSet<UUID> userList, Thread thread) {
        EntityRepository repository = Entity.getEntityRepository("user");
        URI urlInstance = thread.getHref();
        userList.forEach(id -> {
            try {
                User user = (User)repository.get(null, (UUID)id, repository.getFields("name,email,href"));
                EmailUtil.getInstance().sendTaskAssignmentNotificationToUser(user.getName(), user.getEmail(), String.format("%s/users/%s/tasks", EmailUtil.getInstance().buildBaseUrl(urlInstance), user.getName()), thread, EmailUtil.getInstance().getTaskAssignmentSubject(), "taskAssignment.ftl");
            }
            catch (IOException ex) {
                LOG.error("Task Email Notification Failed :", (Throwable)ex);
            }
            catch (TemplateException ex) {
                LOG.error("Task Email Notification Template Parsing Exception :", (Throwable)ex);
            }
        });
    }

    private void handleTestResultEmailNotification(ChangeEvent changeEvent) {
        FieldChange fieldChange;
        String updatedField;
        if (Objects.nonNull(changeEvent.getChangeDescription()) && (updatedField = (fieldChange = (FieldChange)changeEvent.getChangeDescription().getFieldsUpdated().get(0)).getName()).equals("testCaseResult")) {
            TestCaseResult result = (TestCaseResult)fieldChange.getNewValue();
            TestResultNotificationConfiguration testNotificationSetting = SettingsCache.getInstance().getSetting(SettingsType.TEST_RESULT_NOTIFICATION_CONFIGURATION, TestResultNotificationConfiguration.class);
            if (testNotificationSetting.getEnabled().booleanValue() && testNotificationSetting.getOnResult().contains(result.getTestCaseStatus())) {
                List receivers;
                List list = receivers = testNotificationSetting.getReceivers() != null ? testNotificationSetting.getReceivers() : new ArrayList();
                if (testNotificationSetting.getSendToOwners().booleanValue()) {
                    TestCase entity = (TestCase)changeEvent.getEntity();
                    List<CollectionDAO.EntityRelationshipRecord> tableToTestRecord = this.dao.relationshipDAO().findFrom(entity.getId().toString(), "testCase", Relationship.CONTAINS.ordinal(), "table");
                    tableToTestRecord.forEach(tableRecord -> {
                        List<CollectionDAO.EntityRelationshipRecord> tableOwners = this.dao.relationshipDAO().findFrom(tableRecord.getId().toString(), "table", Relationship.OWNS.ordinal());
                        tableOwners.forEach(owner -> {
                            try {
                                if ("user".equals(owner.getType())) {
                                    User user = (User)this.dao.userDAO().findEntityById(owner.getId());
                                    receivers.add(user.getEmail());
                                } else if ("team".equals(owner.getType())) {
                                    Team team = (Team)this.dao.teamDAO().findEntityById(owner.getId());
                                    List<CollectionDAO.EntityRelationshipRecord> records = this.dao.relationshipDAO().findTo(team.getId().toString(), "team", Relationship.HAS.ordinal(), "user");
                                    records.forEach(userRecord -> {
                                        try {
                                            User user = (User)this.dao.userDAO().findEntityById(userRecord.getId());
                                            receivers.add(user.getEmail());
                                        }
                                        catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }
                                    });
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    });
                }
                this.sendTestResultEmailNotifications(receivers, (TestCase)changeEvent.getEntity(), result);
            }
        }
    }

    private void sendTestResultEmailNotifications(List<String> emails, TestCase testCase, TestCaseResult result) {
        emails.forEach(email -> {
            URI urlInstance = testCase.getHref();
            String testLinkUrl = String.format("%s/table/%s/activity_feed", EmailUtil.getInstance().buildBaseUrl(urlInstance), testCase.getEntityFQN());
            try {
                EmailUtil.getInstance().sendTestResultEmailNotificationToUser((String)email, testLinkUrl, testCase.getName(), result, EmailUtil.getInstance().getTestResultSubject(), "testResultStatus.ftl");
            }
            catch (IOException e) {
                LOG.error("TestResult Email Notification Failed :", (Throwable)e);
            }
            catch (TemplateException e) {
                LOG.error("Task Email Notification Template Parsing Exception :", (Throwable)e);
            }
        });
    }
}

