/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.csv;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;

public final class CsvUtil {
    public static final String SEPARATOR = ",";
    public static final String FIELD_SEPARATOR = ";";
    public static final String LINE_SEPARATOR = "\r\n";

    private CsvUtil() {
    }

    public static String formatCsv(CsvFile csvFile) throws IOException {
        StringWriter writer = new StringWriter();
        List<String> headers = CsvUtil.getHeaders(csvFile.getHeaders());
        CSVFormat csvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(headers.toArray(new String[0])).build();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, csvFormat);){
            for (List record : CommonUtil.listOrEmpty((List)csvFile.getRecords())) {
                printer.printRecord((Iterable)record);
            }
        }
        return writer.toString();
    }

    public static List<String> getHeaders(List<CsvHeader> csvHeaders) {
        ArrayList<String> headers = new ArrayList<String>();
        for (CsvHeader header : csvHeaders) {
            String headerString = header.getRequired() != false ? String.format("%s*", header.getName()) : header.getName();
            headers.add(CsvUtil.quoteField(headerString));
        }
        return headers;
    }

    public static String recordToString(CSVRecord record) {
        return CsvUtil.recordToString(record.toList());
    }

    public static String recordToString(List<String> fields) {
        return String.join((CharSequence)SEPARATOR, fields);
    }

    public static String recordToString(String[] fields) {
        return String.join((CharSequence)SEPARATOR, fields);
    }

    public static List<String> fieldToStrings(String field) {
        return field == null ? null : CommonUtil.listOf((Object[])field.split(FIELD_SEPARATOR));
    }

    public static String quote(String field) {
        return String.format("\"%s\"", field);
    }

    public static String quoteField(String field) {
        return field == null ? "" : (field.contains(SEPARATOR) ? CsvUtil.quote(field) : field);
    }

    public static String quoteField(List<String> field) {
        return CommonUtil.nullOrEmpty(field) ? "" : field.stream().map(str -> str.contains(SEPARATOR) || str.contains(FIELD_SEPARATOR) ? CsvUtil.quote(str) : str).collect(Collectors.joining(FIELD_SEPARATOR));
    }

    public static List<String> addField(List<String> record, String field) {
        record.add(CsvUtil.quoteField(field));
        return record;
    }

    public static List<String> addFieldList(List<String> record, List<String> field) {
        record.add(CsvUtil.quoteField(field));
        return record;
    }

    public static List<String> addEntityReferences(List<String> record, List<EntityReference> refs) {
        record.add(CommonUtil.nullOrEmpty(refs) ? null : refs.stream().map(EntityReference::getFullyQualifiedName).collect(Collectors.joining(FIELD_SEPARATOR)));
        return record;
    }

    public static List<String> addEntityReference(List<String> record, EntityReference ref) {
        record.add(CommonUtil.nullOrEmpty((Object)ref) ? null : CsvUtil.quoteField(ref.getFullyQualifiedName()));
        return record;
    }

    public static List<String> addTagLabels(List<String> record, List<TagLabel> tags) {
        record.add(CommonUtil.nullOrEmpty(tags) ? null : tags.stream().map(TagLabel::getTagFQN).collect(Collectors.joining(FIELD_SEPARATOR)));
        return record;
    }
}

