/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.openmetadata.service.util.MicrometerBundleSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAnalyticEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebAnalyticEventHandler.class);
    private PrometheusMeterRegistry prometheusMeterRegistry;
    private String clusterName;
    public static final String WEB_ANALYTIC_ENDPOINT = "v1/analytics/webAnalyticEvent/collect";
    private static final String COUNTER_NAME = "web.analytics.events";

    @Override
    public void init(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        this.prometheusMeterRegistry = MicrometerBundleSingleton.prometheusMeterRegistry;
        this.clusterName = config.getClusterName();
    }

    @Override
    public Void process(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        UriInfo uriInfo = requestContext.getUriInfo();
        if (uriInfo.getPath().contains(WEB_ANALYTIC_ENDPOINT)) {
            String username = "anonymous";
            if (requestContext.getSecurityContext().getUserPrincipal() != null) {
                username = requestContext.getSecurityContext().getUserPrincipal().getName();
            }
            this.incrementMetric(username);
        }
        return null;
    }

    private void incrementMetric(String username) {
        Counter.builder((String)COUNTER_NAME).tags(new String[]{"clusterName", this.clusterName, "username", username}).register((MeterRegistry)this.prometheusMeterRegistry).increment();
    }

    @Override
    public void close() {
        this.prometheusMeterRegistry.close();
    }
}

