/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;

public class DataInsightChartRepository
extends EntityRepository<DataInsightChart> {
    public static final String COLLECTION_PATH = "/v1/dataInsight";
    public static final String LAST_SESSION = "lastSession";
    private static final String UPDATE_FIELDS = "owner";
    private static final String PATCH_FIELDS = "owner";
    private static final String DATA_ENTITY_TYPE = "data.entityType";
    private static final String TIMESTAMP = "timestamp";
    private static final String ENTITY_COUNT = "entityCount";
    private static final String DATA_ENTITY_COUNT = "data.entityCount";
    private static final String ENTITY_TYPE = "entityType";
    private static final String COMPLETED_DESCRIPTION_FRACTION = "completedDescriptionFraction";
    private static final String DATA_COMPLETED_DESCRIPTIONS = "data.completedDescriptions";
    private static final String HAS_OWNER_FRACTION = "hasOwnerFraction";
    private static final String DATA_HAS_OWNER = "data.hasOwner";
    private static final String ENTITY_TIER = "entityTier";
    private static final String DATA_ENTITY_TIER = "data.entityTier";
    private static final String DATA_TEAM = "data.team";
    private static final String DATA_USER_NAME = "data.userName";
    private static final String DATA_PAGE_VIEWS = "data.totalPageView";
    private static final String DATA_SESSIONS = "data.totalSessions";
    private static final String SESSIONS = "sessions";
    private static final String PAGE_VIEWS = "pageViews";
    private static final String DATA_LAST_SESSION = "data.lastSession";
    private static final String SESSION_DURATION = "sessionDuration";
    private static final String DATA_TOTAL_SESSION_DURATION = "data.totalSessionDuration";
    private static final String DATA_VIEWS = "data.views";
    private static final String ENTITY_FQN = "entityFqn";
    private static final String DATA_ENTITY_FQN = "data.entityFqn";
    private static final String OWNER = "owner";
    private static final String DATA_OWNER = "data.owner";
    private static final String USER_NAME = "userName";
    private static final String TEAM = "team";
    private static final String ENTITY_HREF = "entityHref";
    private static final String DATA_ENTITY_HREF = "data.entityHref";
    private static final List<String> SUPPORTS_TEAM_FILTER = Arrays.asList("TotalEntitiesByType", "TotalEntitiesByTier", "PercentageOfEntitiesWithDescriptionByType", "PercentageOfEntitiesWithOwnerByType", "DailyActiveUsers", "MostActiveUsers");
    private static final List<String> SUPPORTS_TIER_FILTER = Arrays.asList("TotalEntitiesByType", "TotalEntitiesByTier", "PercentageOfEntitiesWithDescriptionByType", "PercentageOfEntitiesWithOwnerByType", "PageViewsByEntities", "MostViewedEntities");

    public DataInsightChartRepository(CollectionDAO dao) {
        super(COLLECTION_PATH, "dataInsightChart", DataInsightChart.class, dao.dataInsightChartDAO(), dao, "owner", "owner");
    }

    @Override
    public DataInsightChart setFields(DataInsightChart entity, EntityUtil.Fields fields) {
        return entity;
    }

    @Override
    public void prepare(DataInsightChart entity) {
    }

    @Override
    public void storeEntity(DataInsightChart entity, boolean update) throws IOException {
        EntityReference owner = entity.getOwner();
        entity.withOwner(null).withHref(null);
        this.store(entity, update);
        entity.withOwner(owner);
    }

    @Override
    public void storeRelationships(DataInsightChart entity) {
        this.storeOwner(entity, entity.getOwner());
    }

    public SearchSourceBuilder buildQueryFilter(Long startTs, Long endTs, String tier, String team, String dataInsightChartName) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder searchQueryFiler = new BoolQueryBuilder();
        if (team != null && SUPPORTS_TEAM_FILTER.contains(dataInsightChartName)) {
            List<String> teamArray = Arrays.asList(team.split("\\s*,\\s*"));
            BoolQueryBuilder teamQueryFilter = QueryBuilders.boolQuery();
            teamQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)DATA_TEAM, teamArray));
            searchQueryFiler.must((QueryBuilder)teamQueryFilter);
        }
        if (tier != null && SUPPORTS_TIER_FILTER.contains(dataInsightChartName)) {
            List<String> tierArray = Arrays.asList(tier.split("\\s*,\\s*"));
            BoolQueryBuilder tierQueryFilter = QueryBuilders.boolQuery();
            tierQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)DATA_ENTITY_TIER, tierArray));
            searchQueryFiler.must((QueryBuilder)tierQueryFilter);
        }
        RangeQueryBuilder dateQueryFilter = QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)startTs).lte((Object)endTs);
        searchQueryFiler.must((QueryBuilder)dateQueryFilter);
        return searchSourceBuilder.query((QueryBuilder)searchQueryFiler).fetchSource(false);
    }

    public AbstractAggregationBuilder buildQueryAggregation(DataInsightChartResult.DataInsightChartType dataInsightChartName) throws IllegalArgumentException {
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)TIMESTAMP).field(TIMESTAMP)).calendarInterval(DateHistogramInterval.DAY);
        SumAggregationBuilder sumEntityCountAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)ENTITY_COUNT).field(DATA_ENTITY_COUNT);
        switch (dataInsightChartName) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_TYPE).field(DATA_ENTITY_TYPE)).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)COMPLETED_DESCRIPTION_FRACTION).field(DATA_COMPLETED_DESCRIPTIONS);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_TYPE).field(DATA_ENTITY_TYPE)).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)HAS_OWNER_FRACTION).field(DATA_HAS_OWNER);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TIER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_TIER).field(DATA_ENTITY_TIER)).missing((Object)"NoTier")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_TYPE).field(DATA_ENTITY_TYPE)).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case DAILY_ACTIVE_USERS: {
                return dateHistogramAggregationBuilder;
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_TYPE).field(DATA_ENTITY_TYPE)).size(1000);
                SumAggregationBuilder sumPageViewsByEntityTypes = (SumAggregationBuilder)AggregationBuilders.sum((String)PAGE_VIEWS).field(DATA_VIEWS);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumPageViewsByEntityTypes));
            }
            case MOST_VIEWED_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_FQN).field(DATA_ENTITY_FQN)).size(10).order(BucketOrder.aggregation((String)PAGE_VIEWS, (boolean)false));
                TermsAggregationBuilder ownerTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"owner").field(DATA_OWNER);
                TermsAggregationBuilder entityTypeTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_TYPE).field(DATA_ENTITY_TYPE);
                TermsAggregationBuilder entityHrefAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)ENTITY_HREF).field(DATA_ENTITY_HREF);
                SumAggregationBuilder sumEntityPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)PAGE_VIEWS).field(DATA_VIEWS);
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)ownerTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityTypeTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityHrefAggregationBuilder);
            }
            case MOST_ACTIVE_USERS: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)USER_NAME).field(DATA_USER_NAME)).size(10).order(BucketOrder.aggregation((String)SESSIONS, (boolean)false));
                TermsAggregationBuilder teamTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)TEAM).field(DATA_TEAM);
                SumAggregationBuilder sumSessionAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)SESSIONS).field(DATA_SESSIONS);
                SumAggregationBuilder sumUserPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)PAGE_VIEWS).field(DATA_PAGE_VIEWS);
                MaxAggregationBuilder lastSessionAggregationBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)LAST_SESSION).field(DATA_LAST_SESSION);
                SumAggregationBuilder sumSessionDurationAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)SESSION_DURATION).field(DATA_TOTAL_SESSION_DURATION);
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumUserPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)lastSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumSessionDurationAggregationBuilder)).subAggregation((AggregationBuilder)teamTermsAggregationBuilder);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid dataInsightChartType name %s", dataInsightChartName));
    }
}

