/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class DatabaseSchemaRepository
extends EntityRepository<DatabaseSchema> {
    private static final String DATABASE_SCHEMA_UPDATE_FIELDS = "owner";
    private static final String DATABASE_SCHEMA_PATCH_FIELDS = "owner";

    public DatabaseSchemaRepository(CollectionDAO dao) {
        super("v1/databaseSchemas/", "databaseSchema", DatabaseSchema.class, dao.databaseSchemaDAO(), dao, "owner", "owner");
    }

    @Override
    public void setFullyQualifiedName(DatabaseSchema schema) {
        schema.setFullyQualifiedName(FullyQualifiedName.add(schema.getDatabase().getFullyQualifiedName(), schema.getName()));
    }

    @Override
    public void prepare(DatabaseSchema schema) throws IOException {
        this.populateDatabase(schema);
    }

    @Override
    public void storeEntity(DatabaseSchema schema, boolean update) throws IOException {
        EntityReference owner = schema.getOwner();
        EntityReference service = schema.getService();
        schema.withOwner(null).withService(null).withHref(null);
        this.store(schema, update);
        schema.withOwner(owner).withService(service);
    }

    @Override
    public void storeRelationships(DatabaseSchema schema) {
        EntityReference database = schema.getDatabase();
        this.addRelationship(database.getId(), schema.getId(), database.getType(), "databaseSchema", Relationship.CONTAINS);
        this.storeOwner(schema, schema.getOwner());
    }

    private List<EntityReference> getTables(DatabaseSchema schema) throws IOException {
        if (schema == null) {
            return Collections.emptyList();
        }
        List<CollectionDAO.EntityRelationshipRecord> tableIds = this.findTo(schema.getId(), "databaseSchema", Relationship.CONTAINS, "table");
        return EntityUtil.populateEntityReferences(tableIds, "table");
    }

    @Override
    public DatabaseSchema setFields(DatabaseSchema schema, EntityUtil.Fields fields) throws IOException {
        this.setDefaultFields(schema);
        schema.setOwner(fields.contains("owner") ? this.getOwner(schema) : null);
        schema.setTables(fields.contains("tables") ? this.getTables(schema) : null);
        return schema.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), schema.getId()) : null);
    }

    private void setDefaultFields(DatabaseSchema schema) throws IOException {
        EntityReference databaseRef = this.getContainer(schema.getId());
        Database database = (Database)Entity.getEntity(databaseRef, EntityUtil.Fields.EMPTY_FIELDS, Include.ALL);
        schema.withDatabase(databaseRef).withService(database.getService());
    }

    @Override
    public void restorePatchAttributes(DatabaseSchema original, DatabaseSchema updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    private void populateDatabase(DatabaseSchema schema) throws IOException {
        Database database = (Database)Entity.getEntity(schema.getDatabase(), "owner", Include.ALL);
        schema.withDatabase(database.getEntityReference()).withService(database.getService()).withServiceType(database.getServiceType());
        schema.withOwner(schema.getOwner() == null ? database.getOwner() : schema.getOwner());
    }
}

