/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.jsonwebtoken.lang.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.json.JSONObject;
import org.openmetadata.schema.api.feed.CloseTask;
import org.openmetadata.schema.api.feed.EntityLinkThreadCount;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.api.feed.ThreadCount;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Reaction;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Task;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.feeds.FeedResource;
import org.openmetadata.service.resources.feeds.FeedUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedRepository {
    private static final Logger LOG = LoggerFactory.getLogger(FeedRepository.class);
    private static final String UNSUPPORTED_FIELD_NAME_FOR_TASK = "The field name %s is not supported for %s task.";
    private final CollectionDAO dao;

    public FeedRepository(CollectionDAO dao) {
        this.dao = dao;
    }

    @Transaction
    public int getNextTaskId() {
        this.dao.feedDAO().updateTaskId();
        return this.dao.feedDAO().getTaskId();
    }

    @Transaction
    public Thread create(Thread thread, UUID entityId, EntityReference entityOwner, MessageParser.EntityLink about) throws IOException {
        String createdBy = thread.getCreatedBy();
        User createdByUser = (User)this.dao.userDAO().findEntityByName(createdBy);
        thread.withEntityId(entityId);
        if (thread.getType().equals((Object)ThreadType.Task)) {
            thread.withTask(thread.getTask().withId(Integer.valueOf(this.getNextTaskId())));
        }
        if (thread.getType().equals((Object)ThreadType.Announcement)) {
            this.validateAnnouncement(thread.getAnnouncement());
            long startTime = thread.getAnnouncement().getStartTime();
            long endTime = thread.getAnnouncement().getEndTime();
            List<String> announcements = this.dao.feedDAO().listAnnouncementBetween(entityId.toString(), startTime, endTime);
            if (announcements.size() > 0) {
                throw new IllegalArgumentException("There is already an announcement scheduled that overlaps with the given start time and end time");
            }
        }
        this.dao.feedDAO().insert(JsonUtils.pojoToJson(thread));
        this.dao.relationshipDAO().insert(createdByUser.getId(), thread.getId(), "user", "THREAD", Relationship.CREATED.ordinal());
        this.dao.fieldRelationshipDAO().insert(thread.getId().toString(), about.getFullyQualifiedFieldValue(), "THREAD", about.getFullyQualifiedFieldType(), Relationship.IS_ABOUT.ordinal(), null);
        if (entityOwner != null) {
            this.dao.relationshipDAO().insert(thread.getId(), entityOwner.getId(), "THREAD", entityOwner.getType(), Relationship.ADDRESSED_TO.ordinal());
        }
        this.storeMentions(thread, thread.getMessage());
        return thread;
    }

    @Transaction
    public Thread create(Thread thread) throws IOException {
        MessageParser.EntityLink about = MessageParser.EntityLink.parse(thread.getAbout());
        EntityReference aboutRef = EntityUtil.validateEntityLink(about);
        EntityReference owner = Entity.getOwner(aboutRef);
        UUID entityId = aboutRef.getId();
        return this.create(thread, entityId, owner, about);
    }

    public Thread get(String id) throws IOException {
        Thread thread = EntityUtil.validate(id, this.dao.feedDAO().findById(id), Thread.class);
        this.sortPosts(thread);
        return thread;
    }

    public Thread getTask(Integer id) throws IOException {
        Thread task = EntityUtil.validate(id.toString(), this.dao.feedDAO().findByTaskId(id), Thread.class);
        this.sortPosts(task);
        return this.populateAssignees(task);
    }

    public RestUtil.PatchResponse<Thread> closeTask(UriInfo uriInfo, Thread thread, String user, CloseTask closeTask) throws IOException {
        this.closeTask(thread, user, closeTask.getComment());
        Thread updatedHref = FeedResource.addHref(uriInfo, thread);
        return new RestUtil.PatchResponse<Thread>(Response.Status.OK, updatedHref, "entityUpdated");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performTask(TaskDetails task, MessageParser.EntityLink entityLink, EntityReference reference, UriInfo uriInfo, String newValue, String user) throws IOException {
        TaskType taskType = task.getType();
        List<TaskType> descriptionTasks = List.of(TaskType.RequestDescription, TaskType.UpdateDescription);
        List<TaskType> tagTasks = List.of(TaskType.RequestTag, TaskType.UpdateTag);
        List supportedTasks = Stream.concat(descriptionTasks.stream(), tagTasks.stream()).collect(Collectors.toList());
        if (!supportedTasks.contains(taskType)) return;
        EntityRepository repository = Entity.getEntityRepository(reference.getType());
        String json = repository.dao.findJsonByFqn(entityLink.getEntityFQN(), Include.ALL);
        switch (entityLink.getEntityType()) {
            case "table": {
                Table table = JsonUtils.readValue(json, Table.class);
                String oldJson = JsonUtils.pojoToJson(table);
                if (entityLink.getFieldName() == null) throw new IllegalArgumentException(String.format("The Entity link with no field name - %s is not supported for %s task.", entityLink, task.getType()));
                if (entityLink.getFieldName().equals("columns")) {
                    Optional<Column> col = table.getColumns().stream().filter(c -> c.getName().equals(entityLink.getArrayFieldName())).findFirst();
                    if (!col.isPresent()) throw new IllegalArgumentException(String.format("The Column with name '%s' is not found in the table.", entityLink.getArrayFieldName()));
                    Column column = col.get();
                    if (descriptionTasks.contains(taskType)) {
                        column.setDescription(newValue);
                    } else if (tagTasks.contains(taskType)) {
                        List<TagLabel> tags = JsonUtils.readObjects(newValue, TagLabel.class);
                        column.setTags(tags);
                    }
                } else if (descriptionTasks.contains(taskType) && entityLink.getFieldName().equals("description")) {
                    table.setDescription(newValue);
                } else {
                    if (!tagTasks.contains(taskType) || !entityLink.getFieldName().equals("tags")) throw new IllegalArgumentException(String.format(UNSUPPORTED_FIELD_NAME_FOR_TASK, entityLink.getFieldName(), task.getType()));
                    List<TagLabel> tags = JsonUtils.readObjects(newValue, TagLabel.class);
                    table.setTags(tags);
                }
                String updatedEntityJson = JsonUtils.pojoToJson(table);
                JsonPatch patch = JsonUtils.getJsonPatch(oldJson, updatedEntityJson);
                repository.patch(uriInfo, table.getId(), user, patch);
                return;
            }
            case "topic": {
                Topic topic = JsonUtils.readValue(json, Topic.class);
                String oldJson = JsonUtils.pojoToJson(topic);
                if (descriptionTasks.contains(taskType) && entityLink.getFieldName().equals("description")) {
                    topic.setDescription(newValue);
                } else {
                    if (!tagTasks.contains(taskType) || !entityLink.getFieldName().equals("tags")) throw new IllegalArgumentException(String.format(UNSUPPORTED_FIELD_NAME_FOR_TASK, entityLink.getFieldName(), task.getType()));
                    List<TagLabel> tags = JsonUtils.readObjects(newValue, TagLabel.class);
                    topic.setTags(tags);
                }
                String updatedEntityJson = JsonUtils.pojoToJson(topic);
                JsonPatch patch = JsonUtils.getJsonPatch(oldJson, updatedEntityJson);
                repository.patch(uriInfo, topic.getId(), user, patch);
                return;
            }
            case "dashboard": {
                Dashboard dashboard = JsonUtils.readValue(json, Dashboard.class);
                String oldJson = JsonUtils.pojoToJson(dashboard);
                if (descriptionTasks.contains(taskType) && entityLink.getFieldName().equals("description")) {
                    dashboard.setDescription(newValue);
                } else {
                    if (!entityLink.getFieldName().equals("charts")) throw new IllegalArgumentException(String.format(UNSUPPORTED_FIELD_NAME_FOR_TASK, entityLink.getFieldName(), task.getType()));
                    Optional<EntityReference> ch = dashboard.getCharts().stream().filter(c -> c.getName().equals(entityLink.getArrayFieldName())).findFirst();
                    if (!ch.isPresent()) throw new IllegalArgumentException(String.format("The Chart with name '%s' is not found in the dashboard.", entityLink.getArrayFieldName()));
                    EntityReference chart = ch.get();
                    if (descriptionTasks.contains(taskType)) {
                        chart.setDescription(newValue);
                    }
                }
                String updatedEntityJson = JsonUtils.pojoToJson(dashboard);
                JsonPatch patch = JsonUtils.getJsonPatch(oldJson, updatedEntityJson);
                repository.patch(uriInfo, dashboard.getId(), user, patch);
                return;
            }
            case "pipeline": {
                Pipeline pipeline = JsonUtils.readValue(json, Pipeline.class);
                String oldJson = JsonUtils.pojoToJson(pipeline);
                if (descriptionTasks.contains(taskType) && entityLink.getFieldName().equals("description")) {
                    pipeline.setDescription(newValue);
                } else {
                    if (!entityLink.getFieldName().equals("tasks")) throw new IllegalArgumentException(String.format(UNSUPPORTED_FIELD_NAME_FOR_TASK, entityLink.getFieldName(), task.getType()));
                    Optional<Task> tsk = pipeline.getTasks().stream().filter(c -> c.getName().equals(entityLink.getArrayFieldName())).findFirst();
                    if (!tsk.isPresent()) throw new IllegalArgumentException(String.format("The Task with name '%s' is not found in the pipeline.", entityLink.getArrayFieldName()));
                    Task pipelineTask = tsk.get();
                    if (descriptionTasks.contains(taskType)) {
                        pipelineTask.setDescription(newValue);
                    } else if (tagTasks.contains(taskType)) {
                        List<TagLabel> tags = JsonUtils.readObjects(newValue, TagLabel.class);
                        pipelineTask.setTags(tags);
                    }
                }
                String updatedEntityJson = JsonUtils.pojoToJson(pipeline);
                JsonPatch patch = JsonUtils.getJsonPatch(oldJson, updatedEntityJson);
                repository.patch(uriInfo, pipeline.getId(), user, patch);
                return;
            }
        }
    }

    public RestUtil.PatchResponse<Thread> resolveTask(UriInfo uriInfo, Thread thread, String user, ResolveTask resolveTask) throws IOException {
        TaskDetails task = thread.getTask();
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(thread.getAbout());
        EntityReference reference = EntityUtil.validateEntityLink(entityLink);
        this.performTask(task, entityLink, reference, uriInfo, resolveTask.getNewValue(), user);
        task.withNewValue(resolveTask.getNewValue());
        this.closeTask(thread, user, null);
        Thread updatedHref = FeedResource.addHref(uriInfo, thread);
        return new RestUtil.PatchResponse<Thread>(Response.Status.OK, updatedHref, "entityUpdated");
    }

    private String getTagFQNs(List<TagLabel> tags) {
        return tags.stream().map(TagLabel::getTagFQN).collect(Collectors.joining(", "));
    }

    private void addClosingPost(Thread thread, String user, String closingComment) throws IOException {
        String message;
        if (closingComment != null) {
            message = String.format("Closed the Task with comment - %s", closingComment);
        } else {
            TaskDetails task = thread.getTask();
            TaskType type = task.getType();
            String oldValue = "";
            if (List.of(TaskType.RequestDescription, TaskType.UpdateDescription).contains(type)) {
                if (task.getOldValue() != null) {
                    oldValue = task.getOldValue();
                }
                message = String.format("Resolved the Task with Description - %s", ChangeEventParser.getPlaintextDiff(ChangeEventParser.PUBLISH_TO.FEED, oldValue, task.getNewValue()));
            } else if (List.of(TaskType.RequestTag, TaskType.UpdateTag).contains(type)) {
                List<TagLabel> tags;
                if (task.getOldValue() != null) {
                    tags = JsonUtils.readObjects(task.getOldValue(), TagLabel.class);
                    oldValue = this.getTagFQNs(tags);
                }
                tags = JsonUtils.readObjects(task.getNewValue(), TagLabel.class);
                String newValue = this.getTagFQNs(tags);
                message = String.format("Resolved the Task with Tag(s) - %s", ChangeEventParser.getPlaintextDiff(ChangeEventParser.PUBLISH_TO.FEED, oldValue, newValue));
            } else {
                message = "Resolved the Task.";
            }
        }
        Post post = new Post().withId(UUID.randomUUID()).withMessage(message).withFrom(user).withReactions(java.util.Collections.emptyList()).withPostTs(Long.valueOf(System.currentTimeMillis()));
        try {
            this.addPostToThread(thread.getId().toString(), post, user);
        }
        catch (IOException exception) {
            LOG.error("Unable to post a reply to the Task upon closing.", (Throwable)exception);
        }
    }

    private void closeTask(Thread thread, String user, String closingComment) throws IOException {
        TaskDetails task = thread.getTask();
        task.withStatus(TaskStatus.Closed).withClosedBy(user).withClosedAt(Long.valueOf(System.currentTimeMillis()));
        thread.withTask(task).withUpdatedBy(user).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        this.dao.feedDAO().update(thread.getId().toString(), JsonUtils.pojoToJson(thread));
        this.addClosingPost(thread, user, closingComment);
        this.sortPosts(thread);
    }

    private void storeMentions(Thread thread, String message) {
        List<MessageParser.EntityLink> mentions = MessageParser.getEntityLinks(message);
        mentions.stream().distinct().forEach(mention -> this.dao.fieldRelationshipDAO().insert(mention.getFullyQualifiedFieldValue(), thread.getId().toString(), mention.getFullyQualifiedFieldType(), "THREAD", Relationship.MENTIONED_IN.ordinal(), null));
    }

    @Transaction
    public Thread addPostToThread(String id, Post post, String userName) throws IOException {
        User fromUser = (User)this.dao.userDAO().findEntityByName(post.getFrom());
        Thread thread = EntityUtil.validate(id, this.dao.feedDAO().findById(id), Thread.class);
        thread.withUpdatedBy(userName).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        FeedUtil.addPost(thread, post);
        this.dao.feedDAO().update(id, JsonUtils.pojoToJson(thread));
        boolean relationAlreadyExists = false;
        for (Post p : thread.getPosts()) {
            if (!p.getFrom().equals(post.getFrom())) continue;
            relationAlreadyExists = true;
            break;
        }
        if (!relationAlreadyExists) {
            this.dao.relationshipDAO().insert(fromUser.getId(), thread.getId(), "user", "THREAD", Relationship.REPLIED_TO.ordinal());
        }
        this.storeMentions(thread, post.getMessage());
        this.sortPostsInThreads(List.of(thread));
        return thread;
    }

    public Post getPostById(Thread thread, String postId) {
        Optional<Post> post = thread.getPosts().stream().filter(p -> p.getId().equals(UUID.fromString(postId))).findAny();
        if (post.isEmpty()) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("Post", postId));
        }
        return post.get();
    }

    @Transaction
    public RestUtil.DeleteResponse<Post> deletePost(Thread thread, Post post, String userName) throws IOException {
        List posts = thread.getPosts();
        posts = posts.stream().filter(p -> !p.getId().equals(post.getId())).collect(Collectors.toList());
        thread.withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy(userName).withPosts(posts).withPostsCount(Integer.valueOf(posts.size()));
        this.dao.feedDAO().update(thread.getId().toString(), JsonUtils.pojoToJson(thread));
        return new RestUtil.DeleteResponse<Post>(post, "entityDeleted");
    }

    @Transaction
    public RestUtil.DeleteResponse<Thread> deleteThread(Thread thread, String deletedByUser) {
        String id = thread.getId().toString();
        this.dao.relationshipDAO().deleteAll(id, "THREAD");
        this.dao.fieldRelationshipDAO().deleteAllByPrefix(id);
        this.dao.feedDAO().delete(id);
        LOG.info("{} deleted thread with id {}", (Object)deletedByUser, (Object)thread.getId());
        return new RestUtil.DeleteResponse<Thread>(thread, "entityDeleted");
    }

    public EntityReference getOwnerReference(String username) {
        return ((User)this.dao.userDAO().findEntityByName(username)).getEntityReference();
    }

    @Transaction
    public ThreadCount getThreadsCount(String link, ThreadType type, TaskStatus taskStatus, boolean isResolved) {
        List<List<String>> result;
        ThreadCount threadCount = new ThreadCount();
        ArrayList entityLinkThreadCounts = new ArrayList();
        AtomicInteger totalCount = new AtomicInteger(0);
        if (link == null) {
            result = this.dao.feedDAO().listCountByEntityLink(null, "THREAD", null, Relationship.IS_ABOUT.ordinal(), type, taskStatus, isResolved);
        } else {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(link);
            EntityReference reference = EntityUtil.validateEntityLink(entityLink);
            if (reference.getType().equals("user") || reference.getType().equals("team")) {
                if (reference.getType().equals("user")) {
                    String userId = reference.getId().toString();
                    List<String> teamIds = this.getTeamIds(userId);
                    result = this.dao.feedDAO().listCountByOwner(userId, teamIds, type, isResolved);
                } else {
                    result = new ArrayList<List<String>>();
                }
            } else {
                result = this.dao.feedDAO().listCountByEntityLink(entityLink.getFullyQualifiedFieldValue(), "THREAD", entityLink.getFullyQualifiedFieldType(), Relationship.IS_ABOUT.ordinal(), type, taskStatus, isResolved);
            }
        }
        result.forEach(l -> {
            int count = Integer.parseInt((String)l.get(1));
            entityLinkThreadCounts.add(new EntityLinkThreadCount().withEntityLink((String)l.get(0)).withCount(Integer.valueOf(count)));
            totalCount.addAndGet(count);
        });
        threadCount.withTotalCount(Integer.valueOf(totalCount.get()));
        threadCount.withCounts(entityLinkThreadCounts);
        return threadCount;
    }

    public List<Post> listPosts(String threadId) throws IOException {
        Thread thread = this.get(threadId);
        return thread.getPosts();
    }

    @Transaction
    public final ResultList<Thread> list(String link, int limitPosts, String userId, FilterType filterType, int limit, String pageMarker, boolean isResolved, PaginationType paginationType, ThreadType threadType, TaskStatus taskStatus, Boolean activeAnnouncement) throws IOException {
        int total;
        List<Thread> threads;
        long time = Long.MAX_VALUE;
        if (pageMarker != null) {
            time = Long.parseLong(RestUtil.decodeCursor(pageMarker));
        }
        if (link == null && userId == null) {
            List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listBefore(limit + 1, time, taskStatus, isResolved, threadType, activeAnnouncement) : this.dao.feedDAO().listAfter(limit + 1, time, taskStatus, isResolved, threadType, activeAnnouncement);
            threads = JsonUtils.readObjects(jsons, Thread.class);
            total = this.dao.feedDAO().listCount(taskStatus, isResolved, threadType, activeAnnouncement);
        } else if (link != null) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(link);
            EntityReference reference = EntityUtil.validateEntityLink(entityLink);
            if (reference.getType().equals("user")) {
                FilteredThreads filteredThreads = this.getThreadsByOwner(reference.getId().toString(), limit + 1, time, threadType, isResolved, paginationType);
                threads = filteredThreads.getThreads();
                total = filteredThreads.getTotalCount();
            } else {
                String userName = null;
                ArrayList<String> teamNames = new ArrayList();
                if (userId != null) {
                    List<EntityReference> teams = EntityUtil.populateEntityReferences(this.dao.relationshipDAO().findFrom(userId, "user", Relationship.HAS.ordinal(), "team"), "team");
                    teamNames = teams.stream().map(EntityReference::getName).collect(Collectors.toList());
                    User user = (User)this.dao.userDAO().findEntityById(UUID.fromString(userId));
                    userName = user.getName();
                }
                if (teamNames.isEmpty()) {
                    teamNames = List.of("");
                }
                List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listThreadsByEntityLinkBefore(entityLink.getFullyQualifiedFieldValue(), entityLink.getFullyQualifiedFieldType(), limit + 1, time, threadType, taskStatus, activeAnnouncement, isResolved, Relationship.IS_ABOUT.ordinal(), userName, teamNames, filterType) : this.dao.feedDAO().listThreadsByEntityLinkAfter(entityLink.getFullyQualifiedFieldValue(), entityLink.getFullyQualifiedFieldType(), limit + 1, time, threadType, taskStatus, activeAnnouncement, isResolved, Relationship.IS_ABOUT.ordinal(), userName, teamNames, filterType);
                threads = JsonUtils.readObjects(jsons, Thread.class);
                total = this.dao.feedDAO().listCountThreadsByEntityLink(entityLink.getFullyQualifiedFieldValue(), entityLink.getFullyQualifiedFieldType(), threadType, taskStatus, activeAnnouncement, isResolved, Relationship.IS_ABOUT.ordinal(), userName, teamNames, filterType);
            }
        } else {
            FilteredThreads filteredThreads = ThreadType.Task.equals((Object)threadType) ? (filterType == FilterType.ASSIGNED_BY ? this.getTasksAssignedBy(userId, limit + 1, time, taskStatus, paginationType) : (filterType == FilterType.ASSIGNED_TO ? this.getTasksAssignedTo(userId, limit + 1, time, taskStatus, paginationType) : this.getTasksOfUser(userId, limit + 1, time, taskStatus, paginationType))) : (filterType == FilterType.FOLLOWS ? this.getThreadsByFollows(userId, limit + 1, time, threadType, isResolved, paginationType) : (filterType == FilterType.MENTIONS ? this.getThreadsByMentions(userId, limit + 1, time, threadType, isResolved, paginationType) : this.getThreadsByOwner(userId, limit + 1, time, threadType, isResolved, paginationType)));
            threads = filteredThreads.getThreads();
            total = filteredThreads.getTotalCount();
        }
        this.limitPostsInThreads(threads, limitPosts);
        this.populateAssignees(threads);
        String beforeCursor = null;
        String afterCursor = null;
        if (paginationType == PaginationType.BEFORE) {
            if (threads.size() > limit) {
                threads.remove(0);
                beforeCursor = threads.get(0).getUpdatedAt().toString();
            }
            afterCursor = threads.get(threads.size() - 1).getUpdatedAt().toString();
        } else {
            String string = beforeCursor = pageMarker == null ? null : threads.get(0).getUpdatedAt().toString();
            if (threads.size() > limit) {
                threads.remove(limit);
                afterCursor = threads.get(limit - 1).getUpdatedAt().toString();
            }
        }
        return new ResultList<Thread>(threads, beforeCursor, afterCursor, total);
    }

    private void storeReactions(Thread thread, String user) {
        this.dao.fieldRelationshipDAO().insert(user, thread.getId().toString(), "user", "THREAD", Relationship.REACTED_TO.ordinal(), null);
    }

    @Transaction
    public final RestUtil.PatchResponse<Post> patchPost(Thread thread, Post post, String user, JsonPatch patch) throws IOException {
        Post updated = JsonUtils.applyPatch(post, patch, Post.class);
        this.restorePatchAttributes(post, updated);
        this.populateUserReactions(updated.getReactions());
        List posts = thread.getPosts();
        posts = posts.stream().filter(p -> !p.getId().equals(post.getId())).collect(Collectors.toList());
        posts.add(updated);
        thread.withPosts(posts).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy(user);
        if (!updated.getReactions().isEmpty()) {
            updated.getReactions().forEach(reaction -> this.storeReactions(thread, reaction.getUser().getName()));
        }
        this.sortPosts(thread);
        String change = this.patchUpdate(thread, post, updated) ? "entityUpdated" : "entityNoChange";
        return new RestUtil.PatchResponse<Post>(Response.Status.OK, updated, change);
    }

    @Transaction
    public final RestUtil.PatchResponse<Thread> patchThread(UriInfo uriInfo, UUID id, String user, JsonPatch patch) throws IOException {
        Thread original = this.get(id.toString());
        if (original.getTask() != null) {
            List assignees = original.getTask().getAssignees();
            this.populateAssignees(original);
            assignees.sort(EntityUtil.compareEntityReference);
        }
        Thread updated = JsonUtils.applyPatch(original, patch, Thread.class);
        updated.withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy(user);
        this.restorePatchAttributes(original, updated);
        if (!updated.getReactions().isEmpty()) {
            this.populateUserReactions(updated.getReactions());
            updated.getReactions().forEach(reaction -> this.storeReactions(updated, reaction.getUser().getName()));
        }
        if (updated.getTask() != null) {
            this.populateAssignees(updated);
            updated.getTask().getAssignees().sort(EntityUtil.compareEntityReference);
        }
        if (updated.getAnnouncement() != null) {
            this.validateAnnouncement(updated.getAnnouncement());
            List<String> announcements = this.dao.feedDAO().listAnnouncementBetween(id.toString(), updated.getEntityId().toString(), updated.getAnnouncement().getStartTime(), updated.getAnnouncement().getEndTime());
            if (announcements.size() > 0) {
                throw new IllegalArgumentException("There is already an announcement scheduled that overlaps with the given start time and end time");
            }
        }
        String change = this.patchUpdate(original, updated) ? "entityUpdated" : "entityNoChange";
        this.sortPosts(updated);
        Thread updatedHref = FeedResource.addHref(uriInfo, updated);
        return new RestUtil.PatchResponse<Thread>(Response.Status.OK, updatedHref, change);
    }

    private void validateAnnouncement(AnnouncementDetails announcementDetails) {
        if (announcementDetails.getStartTime() >= announcementDetails.getEndTime()) {
            throw new IllegalArgumentException("Announcement start time must be earlier than the end time");
        }
    }

    private void restorePatchAttributes(Thread original, Thread updated) {
        updated.withId(original.getId()).withAbout(original.getAbout()).withType(original.getType());
    }

    private void restorePatchAttributes(Post original, Post updated) {
        updated.withId(original.getId()).withPostTs(original.getPostTs()).withFrom(original.getFrom());
    }

    private void populateUserReactions(List<Reaction> reactions) {
        if (!Collections.isEmpty(reactions)) {
            reactions.forEach(reaction -> {
                try {
                    reaction.setUser(Entity.getEntityReferenceById("user", reaction.getUser().getId(), Include.ALL));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private boolean patchUpdate(Thread original, Thread updated) throws JsonProcessingException {
        if (this.fieldsChanged(original, updated)) {
            this.populateUserReactions(updated.getReactions());
            this.dao.feedDAO().update(updated.getId().toString(), JsonUtils.pojoToJson(updated));
            return true;
        }
        return false;
    }

    private boolean patchUpdate(Thread thread, Post originalPost, Post updatedPost) throws JsonProcessingException {
        if (this.fieldsChanged(originalPost, updatedPost)) {
            this.dao.feedDAO().update(thread.getId().toString(), JsonUtils.pojoToJson(thread));
            return true;
        }
        return false;
    }

    private boolean fieldsChanged(Post original, Post updated) {
        return !original.getMessage().equals(updated.getMessage()) || Collections.isEmpty((Collection)original.getReactions()) && !Collections.isEmpty((Collection)updated.getReactions()) || !Collections.isEmpty((Collection)original.getReactions()) && Collections.isEmpty((Collection)updated.getReactions()) || original.getReactions().size() != updated.getReactions().size() || !original.getReactions().containsAll(updated.getReactions());
    }

    private boolean fieldsChanged(Thread original, Thread updated) {
        return !original.getResolved().equals(updated.getResolved()) || !original.getMessage().equals(updated.getMessage()) || Collections.isEmpty((Collection)original.getReactions()) && !Collections.isEmpty((Collection)updated.getReactions()) || !Collections.isEmpty((Collection)original.getReactions()) && Collections.isEmpty((Collection)updated.getReactions()) || original.getReactions().size() != updated.getReactions().size() || !original.getReactions().containsAll(updated.getReactions()) || original.getAnnouncement() != null && (!original.getAnnouncement().getDescription().equals(updated.getAnnouncement().getDescription()) || !Objects.equals(original.getAnnouncement().getStartTime(), updated.getAnnouncement().getStartTime()) || !Objects.equals(original.getAnnouncement().getEndTime(), updated.getAnnouncement().getEndTime())) || original.getTask() != null && (original.getTask().getAssignees().size() != updated.getTask().getAssignees().size() || !original.getTask().getAssignees().containsAll(updated.getTask().getAssignees()));
    }

    private void sortPosts(Thread thread) {
        thread.getPosts().sort(Comparator.comparing(Post::getPostTs));
    }

    private void sortPostsInThreads(List<Thread> threads) {
        for (Thread t : threads) {
            this.sortPosts(t);
        }
    }

    private void limitPostsInThreads(List<Thread> threads, int limitPosts) {
        for (Thread t : threads) {
            List posts = t.getPosts();
            this.sortPosts(t);
            if (posts.size() <= limitPosts) continue;
            posts = posts.subList(posts.size() - limitPosts, posts.size());
            t.withPosts(posts);
        }
    }

    private String getUserTeamJsonMysql(String userId, List<String> teamIds) {
        ArrayList<String> result = new ArrayList<String>();
        JSONObject json = this.getUserTeamJson(userId, "user");
        result.add(json.toString());
        teamIds.forEach(id -> result.add(this.getUserTeamJson((String)id, "team").toString()));
        return ((Object)result).toString();
    }

    private List<String> getUserTeamJsonPostgres(String userId, List<String> teamIds) {
        ArrayList<String> result = new ArrayList<String>();
        JSONObject json = this.getUserTeamJson(userId, "user");
        result.add(List.of(json.toString()).toString());
        teamIds.forEach(id -> result.add(List.of(this.getUserTeamJson((String)id, "team").toString()).toString()));
        return result;
    }

    private JSONObject getUserTeamJson(String userId, String type) {
        return new JSONObject().put("id", (Object)userId).put("type", (Object)type);
    }

    private FilteredThreads getTasksAssignedTo(String userId, int limit, long time, TaskStatus status, PaginationType paginationType) throws IOException {
        List<String> teamIds = this.getTeamIds(userId);
        List<String> userTeamJsonPostgres = this.getUserTeamJsonPostgres(userId, teamIds);
        String userTeamJsonMysql = this.getUserTeamJsonMysql(userId, teamIds);
        List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listTasksAssignedToBefore(userTeamJsonPostgres, userTeamJsonMysql, limit, time, status) : this.dao.feedDAO().listTasksAssignedToAfter(userTeamJsonPostgres, userTeamJsonMysql, limit, time, status);
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountTasksAssignedTo(userTeamJsonPostgres, userTeamJsonMysql, status);
        this.sortPostsInThreads(threads);
        return new FilteredThreads(threads, totalCount);
    }

    private void populateAssignees(List<Thread> threads) {
        threads.forEach(this::populateAssignees);
    }

    private Thread populateAssignees(Thread thread) {
        if (thread.getType().equals((Object)ThreadType.Task)) {
            List assignees = thread.getTask().getAssignees();
            for (EntityReference ref : assignees) {
                try {
                    EntityReference ref2 = Entity.getEntityReferenceById(ref.getType(), ref.getId(), Include.ALL);
                    EntityUtil.copy(ref2, ref);
                }
                catch (EntityNotFoundException exception) {
                    if (ref.getType().equals("team")) {
                        ref.setName("DeletedTeam");
                        ref.setDisplayName("Team was deleted");
                        continue;
                    }
                    ref.setName("DeletedUser");
                    ref.setDisplayName("User was deleted");
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
            assignees.sort(EntityUtil.compareEntityReference);
            thread.getTask().setAssignees(assignees);
        }
        return thread;
    }

    private FilteredThreads getTasksOfUser(String userId, int limit, long time, TaskStatus status, PaginationType paginationType) throws IOException {
        User user = (User)this.dao.userDAO().findEntityById(UUID.fromString(userId));
        String username = user.getName();
        List<String> teamIds = this.getTeamIds(userId);
        List<String> userTeamJsonPostgres = this.getUserTeamJsonPostgres(userId, teamIds);
        String userTeamJsonMysql = this.getUserTeamJsonMysql(userId, teamIds);
        List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listTasksOfUserBefore(userTeamJsonPostgres, userTeamJsonMysql, username, limit, time, status) : this.dao.feedDAO().listTasksOfUserAfter(userTeamJsonPostgres, userTeamJsonMysql, username, limit, time, status);
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountTasksOfUser(userTeamJsonPostgres, userTeamJsonMysql, username, status);
        this.sortPostsInThreads(threads);
        return new FilteredThreads(threads, totalCount);
    }

    private FilteredThreads getTasksAssignedBy(String userId, int limit, long time, TaskStatus status, PaginationType paginationType) throws IOException {
        User user = (User)this.dao.userDAO().findEntityById(UUID.fromString(userId));
        String username = user.getName();
        List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listTasksAssignedByBefore(username, limit, time, status) : this.dao.feedDAO().listTasksAssignedByAfter(username, limit, time, status);
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountTasksAssignedBy(username, status);
        this.sortPostsInThreads(threads);
        return new FilteredThreads(threads, totalCount);
    }

    private FilteredThreads getThreadsByOwner(String userId, int limit, long time, ThreadType type, boolean isResolved, PaginationType paginationType) throws IOException {
        List<String> teamIds = this.getTeamIds(userId);
        List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listThreadsByOwnerBefore(userId, teamIds, limit, time, type, isResolved) : this.dao.feedDAO().listThreadsByOwnerAfter(userId, teamIds, limit, time, type, isResolved);
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountThreadsByOwner(userId, teamIds, type, isResolved);
        this.sortPostsInThreads(threads);
        return new FilteredThreads(threads, totalCount);
    }

    private List<String> getTeamIds(String userId) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.dao.relationshipDAO().findFrom(userId, "user", Relationship.HAS.ordinal(), "team");
        ArrayList<String> teamIds = new ArrayList<String>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            teamIds.add(entityRelationshipRecord.getId().toString());
        }
        return teamIds.isEmpty() ? List.of("") : teamIds;
    }

    private FilteredThreads getThreadsByMentions(String userId, int limit, long time, ThreadType type, boolean isResolved, PaginationType paginationType) throws IOException {
        List<EntityReference> teams = EntityUtil.populateEntityReferences(this.dao.relationshipDAO().findFrom(userId, "user", Relationship.HAS.ordinal(), "team"), "team");
        List<Object> teamNames = teams.stream().map(EntityReference::getName).collect(Collectors.toList());
        if (teamNames.isEmpty()) {
            teamNames = List.of("");
        }
        User user = (User)this.dao.userDAO().findEntityById(UUID.fromString(userId));
        List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listThreadsByMentionsBefore(user.getName(), teamNames, limit, time, type, isResolved, Relationship.MENTIONED_IN.ordinal()) : this.dao.feedDAO().listThreadsByMentionsAfter(user.getName(), teamNames, limit, time, type, isResolved, Relationship.MENTIONED_IN.ordinal());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountThreadsByMentions(user.getName(), teamNames, type, isResolved, Relationship.MENTIONED_IN.ordinal());
        this.sortPostsInThreads(threads);
        return new FilteredThreads(threads, totalCount);
    }

    private FilteredThreads getThreadsByFollows(String userId, int limit, long time, ThreadType type, boolean isResolved, PaginationType paginationType) throws IOException {
        List<String> teamIds = this.getTeamIds(userId);
        List<String> jsons = paginationType == PaginationType.BEFORE ? this.dao.feedDAO().listThreadsByFollowsBefore(userId, teamIds, limit, time, type, isResolved, Relationship.FOLLOWS.ordinal()) : this.dao.feedDAO().listThreadsByFollowsAfter(userId, teamIds, limit, time, type, isResolved, Relationship.FOLLOWS.ordinal());
        List<Thread> threads = JsonUtils.readObjects(jsons, Thread.class);
        int totalCount = this.dao.feedDAO().listCountThreadsByFollows(userId, teamIds, type, isResolved, Relationship.FOLLOWS.ordinal());
        this.sortPostsInThreads(threads);
        return new FilteredThreads(threads, totalCount);
    }

    public User findUserByName(String userName) {
        return (User)this.dao.userDAO().findEntityByName(userName);
    }

    public static class FilteredThreads {
        private final List<Thread> threads;
        private final int totalCount;

        public FilteredThreads(List<Thread> threads, int totalCount) {
            this.threads = threads;
            this.totalCount = totalCount;
        }

        public List<Thread> getThreads() {
            return this.threads;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    public static enum PaginationType {
        BEFORE,
        AFTER;

    }

    public static enum FilterType {
        OWNER,
        MENTIONS,
        FOLLOWS,
        ASSIGNED_TO,
        ASSIGNED_BY;

    }
}

