/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.alerts;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.events.CreateAlert;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.entity.alerts.AlertActionStatus;
import org.openmetadata.schema.entity.alerts.EntitySpelFilters;
import org.openmetadata.schema.entity.alerts.TriggerConfig;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Function;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.alerts.ActivityFeedAlertCache;
import org.openmetadata.service.alerts.AlertUtil;
import org.openmetadata.service.alerts.AlertsPublisherManager;
import org.openmetadata.service.jdbi3.AlertRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.policies.PolicyResource;
import org.openmetadata.service.resources.settings.SettingsResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/alerts")
@Api(value="Alerts collection", tags={"Alerts collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="alerts", order=8)
public class AlertResource
extends EntityResource<Alert, AlertRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(AlertResource.class);
    public static final String COLLECTION_PATH = "v1/alerts/";
    private final CollectionDAO daoCollection;
    private final Map<String, EntitySpelFilters> entitySpelFiltersList = new HashMap<String, EntitySpelFilters>();
    public static final String FIELDS = "owner,triggerConfig,filteringRules,alertActions";

    private void initAlerts() throws IOException {
        List<String> filterDataFiles = EntityUtil.getJsonDataResources(".*json/data/alerts/filterData.json$");
        if (filterDataFiles.size() != 1) {
            LOG.warn("Invalid number of filterDataFiles. Only one expected.");
            return;
        }
        String filterDataFile = filterDataFiles.get(0);
        try {
            String json = CommonUtil.getResourceAsStream((ClassLoader)this.getClass().getClassLoader(), (String)filterDataFile);
            List<EntitySpelFilters> filters = JsonUtils.readObjects(json, EntitySpelFilters.class);
            filters.forEach(spelFilter -> this.entitySpelFiltersList.put(spelFilter.getEntityType(), (EntitySpelFilters)spelFilter));
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize the {} from file {}", new Object[]{"filters", filterDataFile, e});
        }
        List<String> alertFile = EntityUtil.getJsonDataResources(".*json/data/alerts/alertsData.json$");
        List<String> alertActionFile = EntityUtil.getJsonDataResources(".*json/data/alerts/alertsActionData.json$");
        String alertDataFile = alertFile.get(0);
        String alertActionDataFile = alertActionFile.get(0);
        Alert activityFeedAlert = null;
        try {
            String actionJson = CommonUtil.getResourceAsStream((ClassLoader)PolicyResource.class.getClassLoader(), (String)alertActionDataFile);
            AlertAction alertActions = JsonUtils.readObjects(actionJson, AlertAction.class).get(0);
            String alertJson = CommonUtil.getResourceAsStream((ClassLoader)this.getClass().getClassLoader(), (String)alertDataFile);
            activityFeedAlert = JsonUtils.readObjects(alertJson, Alert.class).get(0);
            activityFeedAlert.setId(UUID.randomUUID());
            EntityRepository actionEntityRepository = Entity.getEntityRepository("alertAction");
            AlertAction action = (AlertAction)actionEntityRepository.getByName(null, alertActions.getName(), actionEntityRepository.getFields("id"));
            activityFeedAlert.setAlertActions(List.of(action.getEntityReference()));
            ((AlertRepository)this.dao).initializeEntity(activityFeedAlert);
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize the {} from file {}", new Object[]{"filters", alertDataFile, e});
        }
        ActivityFeedAlertCache.initialize(activityFeedAlert.getName(), this.daoCollection);
        List<String> listAllAlerts = this.daoCollection.alertDAO().listAllAlerts(this.daoCollection.alertDAO().getTableName());
        List<Alert> alertList = JsonUtils.readObjects(listAllAlerts, Alert.class);
        for (Alert alert : alertList) {
            if (alert.getName().equals(activityFeedAlert.getName())) continue;
            AlertsPublisherManager.getInstance().addAlertActionPublishers(alert);
        }
    }

    @Override
    public Alert addHref(UriInfo uriInfo, Alert entity) {
        Entity.withHref(uriInfo, entity.getOwner());
        Entity.withHref(uriInfo, entity.getAlertActions());
        return entity;
    }

    public AlertResource(CollectionDAO dao, Authorizer authorizer) {
        super(Alert.class, new AlertRepository(dao), authorizer);
        this.daoCollection = dao;
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) {
        try {
            this.initAlerts();
        }
        catch (Exception ex) {
            LOG.warn("Exception during initialization", (Throwable)ex);
        }
    }

    @GET
    @Operation(operationId="listAlerts", summary="List alerts", tags={"alerts"}, description="Get a list of Alerts", responses={@ApiResponse(responseCode="200", description="List of alerts", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertList.class))})})
    public ResultList<Alert> listAlerts(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,triggerConfig,filteringRules,alertActions")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number alerts returned. (1 to 1000000, default = 10) ") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of alerts before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of alerts after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include);
        return this.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Valid
    @Operation(operationId="getAlertByID", summary="Get a alert", tags={"alerts"}, description="Get a alert by given Id", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=Alert.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public Alert getAlertById(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,triggerConfig,filteringRules,alertActions")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Alert)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/{alertId}/status/{actionId}")
    @Valid
    @Operation(operationId="getAlertActionStatus", summary="Get alert Action status for an alert", tags={"alerts"}, description="Get a alert actions status by given Id , and id of the alert it is bound to", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertActionStatus.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public AlertActionStatus getAlertActionStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="alertId") UUID alertId, @Parameter(description="alertAction Id", schema=@Schema(type="UUID")) @PathParam(value="actionId") UUID alertActionId) {
        return AlertsPublisherManager.getInstance().getStatus(alertId, alertActionId);
    }

    @GET
    @Path(value="/allAlertAction/{alertId}")
    @Valid
    @Operation(operationId="getAllAlertActionForAlert", summary="Get all alert Action of an alert", tags={"alerts"}, description="Get all alert Action of alert by given Id , and id of the alert it is bound to", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertActionStatus.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public List<AlertAction> getAllAlertActionForAlert(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="alertId") UUID alertId) throws IOException {
        return ((AlertRepository)this.dao).getAllAlertActionForAlert(alertId);
    }

    @GET
    @Path(value="/defaultTriggers")
    @Operation(operationId="defaultTriggers", summary="List All Default Triggers Config", tags={"alerts"}, description="Get a List of all OpenMetadata Bootstrapped Alert Filters", responses={@ApiResponse(responseCode="200", description="List of Settings", content={@Content(mediaType="application/json", schema=@Schema(implementation=SettingsResource.SettingsList.class))})})
    public List<TriggerConfig> getAlertBootstrapFilters(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext);
        return AlertUtil.getDefaultAlertTriggers();
    }

    @GET
    @Path(value="/functions")
    @Operation(operationId="listAlertFunctions", summary="Get list of Alert functions used in filtering alert.", tags={"alerts"}, description="Get list of Alert functions used in filtering conditions in alerts")
    public List<Function> listAlertFunctions(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return new ArrayList<Function>(AlertUtil.getAlertFilterFunctions().values());
    }

    @GET
    @Path(value="/entityFunctions")
    @Operation(operationId="listAlertFunctions", summary="Get list of Alert functions used in filtering alert.", tags={"alerts"}, description="Get list of Alert functions used in filtering conditions in alerts")
    public Map<String, EntitySpelFilters> listEntityAlertFunctions(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return this.entitySpelFiltersList;
    }

    @GET
    @Path(value="/validation/condition/{expression}")
    @Operation(operationId="validateCondition", summary="Validate a given condition", tags={"policies"}, description="Validate a given condition expression used in filtering rules.", responses={@ApiResponse(responseCode="204", description="No value is returned"), @ApiResponse(responseCode="400", description="Invalid expression")})
    public void validateCondition(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="expression") String expression) {
        AlertUtil.validateExpression(expression, Boolean.class);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getAlertByFQN", summary="Get a alert by name", tags={"alerts"}, description="Get a alert by name.", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=Alert.class))}), @ApiResponse(responseCode="404", description="Alert for instance {id} is not found")})
    public Alert getAlertByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the alert", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,triggerConfig,filteringRules,alertActions")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Alert)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllAlertVersion", summary="List alert versions", tags={"alerts"}, description="Get a list of all the versions of a alert identified by `id`", responses={@ApiResponse(responseCode="200", description="List of alert versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listAlertVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificAlertVersion", summary="Get a version of the alert", tags={"alerts"}, description="Get a version of the alert by given `id`", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=Alert.class))}), @ApiResponse(responseCode="404", description="Alert for instance {id} and version {version} is not found")})
    public Alert getAlertVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="alert version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Alert)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createAlert", summary="Create a new Alert", tags={"alerts"}, description="Create a new Alert", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateAlert.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createAlert(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAlert create) throws IOException {
        Alert alert = this.getAlert(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, alert);
        AlertsPublisherManager.getInstance().addAlertActionPublishers(alert);
        return response;
    }

    @PUT
    @Operation(operationId="createOrUpdateAlert", summary="Updated an existing or create a new Alert", tags={"alerts"}, description="Updated an existing or create a new alert", responses={@ApiResponse(responseCode="200", description="alert", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateAlert.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response updateAlert(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAlert create) throws IOException {
        Alert alert = this.getAlert(create, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, alert);
        AlertsPublisherManager.getInstance().updateAlertActionPublishers(alert);
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchAlert", summary="Update a Alert", tags={"alerts"}, description="Update an existing alert using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patchAlert(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        Response response = this.patchInternal(uriInfo, securityContext, id, patch);
        AlertsPublisherManager.getInstance().updateAlertActionPublishers((Alert)response.getEntity());
        return response;
    }

    @DELETE
    @Path(value="/{id}")
    @Valid
    @Operation(operationId="deleteAlert", summary="Delete an Alert", tags={"alerts"}, description="Delete an Alert", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=Alert.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public Response deleteAlert(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="alert Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException, InterruptedException {
        Response response = this.delete(uriInfo, securityContext, id, true, true);
        AlertsPublisherManager.getInstance().deleteAlertAllPublishers(id);
        return response;
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteAlertByName", summary="Delete an Alert", tags={"alerts"}, description="Delete an Alert by given `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Entity for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the alert", schema=@Schema(type="string")) @PathParam(value="name") String name) throws IOException {
        return this.deleteByName(uriInfo, securityContext, name, true, true);
    }

    public Alert getAlert(CreateAlert create, String user) throws IOException {
        return this.copy(new Alert(), (CreateEntity)create, user).withTriggerConfig(create.getTriggerConfig()).withFilteringRules(create.getFilteringRules()).withAlertActions(create.getAlertActions());
    }

    public static class AlertList
    extends ResultList<Alert> {
    }
}

