/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.search;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.elasticsearch.search.suggest.completion.context.CategoryQueryContext;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.util.ElasticSearchClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/search")
@Api(value="Search collection", tags={"Search collection"})
@Produces(value={"application/json"})
@Collection(name="search")
public class SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private RestHighLevelClient client;
    private static final Integer MAX_AGGREGATE_SIZE = 50;
    private static final Integer MAX_RESULT_HITS = 10000;
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DESCRIPTION = "description";
    private static final String UNIFIED = "unified";
    private static final NamedXContentRegistry xContentRegistry;

    public void initialize(OpenMetadataApplicationConfig config) {
        if (config.getElasticSearchConfiguration() != null) {
            this.client = ElasticSearchClientUtils.createElasticSearchClient(config.getElasticSearchConfiguration());
        }
    }

    @GET
    @Path(value="/query")
    @Operation(operationId="searchEntitiesWithQuery", summary="Search entities", tags={"search"}, description="Search entities using query test. Use query params `from` and `size` for pagination. Use `sort_field` to sort the results in `sort_order`.", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response search(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. <br/> 1. For listing all tables or topics pass q=* <br/>2. For search tables or topics pass q=*search_term* <br/>3. For searching field names such as search by column_name pass q=column_names:address <br/>4. For searching by tag names pass q=tags:user.email <br/>5. When user selects a filter pass q=query_text AND tags:user.email AND platform:MYSQL <br/>6. Search with multiple values of same filter q=tags:user.email AND tags:user.address <br/> logic operators such as AND and OR must be in uppercase ", required=true) @DefaultValue(value="*") @QueryParam(value="q") String query, @Parameter(description="ElasticSearch Index name, defaults to table_search_index") @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Filter documents by deleted param. By default deleted is false") @DefaultValue(value="false") @QueryParam(value="deleted") @Deprecated(forRemoval=true) boolean deleted, @Parameter(description="From field to paginate the results, defaults to 0") @DefaultValue(value="0") @QueryParam(value="from") int from, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @Parameter(description="Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp") @DefaultValue(value="_score") @QueryParam(value="sort_field") String sortFieldParam, @Parameter(description="Sort order asc for ascending or desc for descending, defaults to desc") @DefaultValue(value="desc") @QueryParam(value="sort_order") SortOrder sortOrder, @Parameter(description="Track Total Hits") @DefaultValue(value="false") @QueryParam(value="track_total_hits") boolean trackTotalHits, @Parameter(description="Elasticsearch query that will be combined with the query_string query generator from the `query` argument") @QueryParam(value="query_filter") String queryFilter, @Parameter(description="Elasticsearch query that will be used as a post_filter") @QueryParam(value="post_filter") String postFilter, @Parameter(description="Get document body for each hit") @DefaultValue(value="true") @QueryParam(value="fetch_source") boolean fetchSource, @Parameter(description="Get only selected fields of the document body for each hit. Empty value will return all fields") @QueryParam(value="include_source_fields") List<String> includeSourceFields) throws IOException {
        XContentParser filterParser;
        SearchSourceBuilder searchSourceBuilder;
        if (CommonUtil.nullOrEmpty((String)query)) {
            query = "*";
        }
        switch (index) {
            case "topic_search_index": {
                searchSourceBuilder = this.buildTopicSearchBuilder(query, from, size);
                break;
            }
            case "dashboard_search_index": {
                searchSourceBuilder = this.buildDashboardSearchBuilder(query, from, size);
                break;
            }
            case "pipeline_search_index": {
                searchSourceBuilder = this.buildPipelineSearchBuilder(query, from, size);
                break;
            }
            case "mlmodel_search_index": {
                searchSourceBuilder = this.buildMlModelSearchBuilder(query, from, size);
                break;
            }
            case "table_search_index": {
                searchSourceBuilder = this.buildTableSearchBuilder(query, from, size);
                break;
            }
            case "user_search_index": {
                searchSourceBuilder = this.buildUserSearchBuilder(query, from, size);
                break;
            }
            case "team_search_index": {
                searchSourceBuilder = this.buildTeamSearchBuilder(query, from, size);
                break;
            }
            case "glossary_search_index": {
                searchSourceBuilder = this.buildGlossaryTermSearchBuilder(query, from, size);
                break;
            }
            case "tag_search_index": {
                searchSourceBuilder = this.buildTagSearchBuilder(query, from, size);
                break;
            }
            default: {
                searchSourceBuilder = this.buildAggregateSearchBuilder(query, from, size);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)queryFilter)) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)postFilter)) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, postFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                searchSourceBuilder.postFilter(filter);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing post_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)deleted)));
        if (!CommonUtil.nullOrEmpty((String)sortFieldParam)) {
            searchSourceBuilder.sort(sortFieldParam, sortOrder);
        }
        searchSourceBuilder.fetchSource(new FetchSourceContext(fetchSource, (String[])includeSourceFields.toArray(String[]::new), new String[0]));
        if (trackTotalHits) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHitsUpTo(MAX_RESULT_HITS.intValue());
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new SearchRequest(new String[]{index}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @GET
    @Path(value="/suggest")
    @Operation(operationId="getSuggestedEntities", summary="Suggest Entities", tags={"search"}, description="Get suggested entities used for auto-completion.", responses={@ApiResponse(responseCode="200", description="Table Suggestion API", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggest.class))})})
    public Response suggest(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Suggest API can be used to auto-fill the entities name while use is typing search text <br/> 1. To get suggest results pass q=us or q=user etc.. <br/> 2. Do not add any wild-cards such as * like in search api <br/> 3. suggest api is a prefix suggestion <br/>", required=true) @QueryParam(value="q") String query, @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Field in object containing valid suggestions. Defaults to 'suggest`. All indices has a `suggest` field, only some indices have other `suggest_*` fields.") @DefaultValue(value="suggest") @QueryParam(value="field") String fieldName, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @Parameter(description="Get document body for each hit") @DefaultValue(value="true") @QueryParam(value="fetch_source") boolean fetchSource, @Parameter(description="Get only selected fields of the document body for each hit. Empty value will return all fields") @QueryParam(value="include_source_fields") List<String> includeSourceFields, @DefaultValue(value="false") @QueryParam(value="deleted") String deleted) throws IOException {
        if (CommonUtil.nullOrEmpty((String)query)) {
            query = "*";
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CompletionSuggestionBuilder suggestionBuilder = ((CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)fieldName).prefix(query, Fuzziness.AUTO).size(size)).skipDuplicates(true);
        if (fieldName.equalsIgnoreCase("suggest")) {
            suggestionBuilder.contexts(Collections.singletonMap("deleted", Collections.singletonList(CategoryQueryContext.builder().setCategory(deleted).build())));
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("metadata-suggest", (SuggestionBuilder)suggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder).timeout(new TimeValue(30L, TimeUnit.SECONDS)).fetchSource(new FetchSourceContext(fetchSource, (String[])includeSourceFields.toArray(String[]::new), new String[0]));
        SearchRequest searchRequest = new SearchRequest(new String[]{index}).source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)suggest.toString()).build();
    }

    @GET
    @Path(value="/aggregate")
    @Operation(operationId="getAggregateFields", summary="Get Aggregated Fields", tags={"search"}, description="Get Aggregated Fields from Entities.", responses={@ApiResponse(responseCode="200", description="Table Aggregate API", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggest.class))})})
    public Response aggregate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Field in an entity.") @QueryParam(value="field") String fieldName, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @DefaultValue(value="false") @QueryParam(value="deleted") String deleted) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)fieldName).field(fieldName)).size(MAX_AGGREGATE_SIZE.intValue()).order(BucketOrder.key((boolean)true))).size(0);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new SearchRequest(new String[]{index}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    private SearchSourceBuilder buildAggregateSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).lenient(Boolean.valueOf(true));
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildTableSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = QueryBuilders.queryStringQuery((String)query).field(DISPLAY_NAME, 20.0f).field(DESCRIPTION, 2.0f).field("columns.name", 2.0f).field("columns.description", 1.0f).field("columns.children.name", 2.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        FieldValueFactorFunctionBuilder boostScoreBuilder = ScoreFunctionBuilders.fieldValueFactorFunction((String)"usageSummary.weeklyStats.count").missing(1.0).factor(4.0f);
        FunctionScoreQueryBuilder.FilterFunctionBuilder[] functions = new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)new MatchNoneQueryBuilder(), (ScoreFunctionBuilder)boostScoreBuilder)};
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])functions);
        HighlightBuilder.Field highlightTableName = new HighlightBuilder.Field(DISPLAY_NAME);
        highlightTableName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("columns.name");
        highlightColumns.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("columns.description");
        highlightColumnDescriptions.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("columns.children.name");
        highlightColumnDescriptions.highlighterType(UNIFIED);
        hb.field(highlightDescription);
        hb.field(highlightTableName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"database.name.keyword").field("database.name.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"databaseSchema.name.keyword").field("databaseSchema.name.keyword"));
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildTopicSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(DISPLAY_NAME, 10.0f).field(DESCRIPTION, 2.0f).field("messageSchema.schemaFields.name", 2.0f).field("messageSchema.schemaFields.description", 1.0f).field("messageSchema.schemaFields.children.name", 2.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTopicName = new HighlightBuilder.Field(DISPLAY_NAME);
        highlightTopicName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightTopicName);
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.description").highlighterType(UNIFIED));
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.children.name").highlighterType(UNIFIED));
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"messageSchema.schemaFields.name").field("messageSchema.schemaFields.name"));
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildDashboardSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(DISPLAY_NAME, 10.0f).field(DESCRIPTION, 2.0f).field("charts.name", 2.0f).field("charts.description").defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDashboardName = new HighlightBuilder.Field(DISPLAY_NAME);
        highlightDashboardName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightCharts = new HighlightBuilder.Field("charts.name");
        highlightCharts.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightChartDescriptions = new HighlightBuilder.Field("charts.description");
        highlightChartDescriptions.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightDashboardName);
        hb.field(highlightCharts);
        hb.field(highlightChartDescriptions);
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildPipelineSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(DISPLAY_NAME, 10.0f).field(DESCRIPTION, 2.0f).field("tasks.name", 2.0f).field("tasks.description").defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field(DISPLAY_NAME);
        highlightPipelineName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("tasks.name");
        highlightTasks.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("tasks.description");
        highlightTaskDescriptions.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildMlModelSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(DISPLAY_NAME, 10.0f).field(DESCRIPTION, 2.0f).field("mlFeatures.name", 2.0f).field("mlFeatures.description").defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field(DISPLAY_NAME);
        highlightPipelineName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("mlFeatures.name");
        highlightTasks.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("mlFeatures.description");
        highlightTaskDescriptions.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder searchBuilder(QueryBuilder queryBuilder, HighlightBuilder hb, int from, int size) {
        SearchSourceBuilder builder = new SearchSourceBuilder().query(queryBuilder).from(from).size(size);
        if (hb != null) {
            hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
            hb.postTags(new String[]{"</span>"});
            builder.highlighter(hb);
        }
        return builder;
    }

    private SearchSourceBuilder addAggregation(SearchSourceBuilder builder) {
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceType").field("serviceType")).size(MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service.name.keyword").field("service.name.keyword")).size(MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("entityType")).size(MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tier.tagFQN").field("tier.tagFQN")).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN")).size(MAX_AGGREGATE_SIZE.intValue()));
        return builder;
    }

    private SearchSourceBuilder buildUserSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(DISPLAY_NAME, 5.0f).field(NAME, 3.0f).lenient(Boolean.valueOf(true));
        return this.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private SearchSourceBuilder buildTeamSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(DISPLAY_NAME, 5.0f).field(NAME, 3.0f).lenient(Boolean.valueOf(true));
        return this.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private SearchSourceBuilder buildGlossaryTermSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 10.0f).field(DESCRIPTION, 3.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field(NAME);
        highlightGlossaryName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return this.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private SearchSourceBuilder buildTagSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 10.0f).field(DESCRIPTION, 3.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTagName = new HighlightBuilder.Field(NAME);
        highlightTagName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightTagName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return this.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    static {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, List.of());
        xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
    }
}

