/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.util;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.util.EntitiesCount;
import org.openmetadata.schema.util.ServicesCount;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.UtilRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.security.Authorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/util")
@Api(value="Util collection", tags={"Util collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="util")
public class UtilResource {
    private static final Logger LOG = LoggerFactory.getLogger(UtilResource.class);
    public static final String COLLECTION_PATH = "/v1/util";
    private final UtilRepository utilRepository;
    private final Authorizer authorizer;

    public UtilResource(CollectionDAO dao, Authorizer authorizer) {
        Objects.requireNonNull(dao, "UtilRepository must not be null");
        this.utilRepository = new UtilRepository(dao.utilDAO());
        this.authorizer = authorizer;
    }

    @GET
    @Path(value="/entities/count")
    @Operation(operationId="listEntitiesCount", summary="List All Entities Counts", tags={"util"}, description="Get a List of all Entities Count", responses={@ApiResponse(responseCode="200", description="List of Entities Count", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntitiesCount.class))})})
    public EntitiesCount listEntitiesCount(@Context UriInfo uriInfo, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return this.utilRepository.getAllEntitiesCount(filter);
    }

    @GET
    @Path(value="/services/count")
    @Operation(operationId="listServicesCount", summary="List All Services Counts", tags={"util"}, description="Get a List of all Entities Count", responses={@ApiResponse(responseCode="200", description="List of Services Count", content={@Content(mediaType="application/json", schema=@Schema(implementation=ServicesCount.class))})})
    public ServicesCount listServicesCount(@Context UriInfo uriInfo, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return this.utilRepository.getAllServicesCount(filter);
    }
}

