/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.secrets.AWSSSMSecretsManager;
import org.openmetadata.service.secrets.AWSSecretsManager;
import org.openmetadata.service.secrets.InMemorySecretsManager;
import org.openmetadata.service.secrets.NoopSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerConfiguration;

public class SecretsManagerFactory {
    private static SecretsManager secretsManager;

    private SecretsManagerFactory() {
    }

    public static SecretsManager createSecretsManager(SecretsManagerConfiguration config, String clusterName) {
        if (secretsManager != null) {
            return secretsManager;
        }
        SecretsManagerProvider secretsManagerProvider = config != null && config.getSecretsManager() != null ? config.getSecretsManager() : SecretsManagerConfiguration.DEFAULT_SECRET_MANAGER;
        switch (secretsManagerProvider) {
            case NOOP: 
            case AWS_SSM: 
            case AWS: {
                secretsManager = NoopSecretsManager.getInstance(clusterName, secretsManagerProvider);
                break;
            }
            case MANAGED_AWS: {
                secretsManager = AWSSecretsManager.getInstance(config, clusterName);
                break;
            }
            case MANAGED_AWS_SSM: {
                secretsManager = AWSSSMSecretsManager.getInstance(config, clusterName);
                break;
            }
            case IN_MEMORY: {
                secretsManager = InMemorySecretsManager.getInstance(clusterName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not implemented secret manager store: " + secretsManagerProvider);
            }
        }
        return secretsManager;
    }

    @VisibleForTesting
    public static void setSecretsManager(SecretsManager secretsManager) {
        SecretsManagerFactory.secretsManager = secretsManager;
    }

    public static SecretsManager getSecretsManager() {
        return secretsManager;
    }
}

