/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Permission;
import org.openmetadata.schema.type.ResourceDescriptor;
import org.openmetadata.schema.type.ResourcePermission;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyEvaluator.class);

    private PolicyEvaluator() {
    }

    public static void hasPermission(@NonNull SubjectContext subjectContext, @NonNull ResourceContextInterface resourceContext, @NonNull OperationContext operationContext) throws IOException {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        if (resourceContext == null) {
            throw new NullPointerException("resourceContext is marked non-null but is null");
        }
        if (operationContext == null) {
            throw new NullPointerException("operationContext is marked non-null but is null");
        }
        PolicyEvaluator.evaluateDenySubjectPolicies(subjectContext, resourceContext, operationContext);
        PolicyEvaluator.evaluateDenyResourcePolicies(subjectContext, resourceContext, operationContext);
        PolicyEvaluator.evaluateAllowSubjectPolicies(subjectContext, resourceContext, operationContext);
        PolicyEvaluator.evaluateAllowResourcePolicies(subjectContext, resourceContext, operationContext);
        if (!operationContext.getOperations().isEmpty()) {
            throw new AuthorizationException(CatalogExceptionMessage.permissionNotAllowed(subjectContext.getUser().getName(), operationContext.getOperations()));
        }
    }

    private static void evaluateDenySubjectPolicies(SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext) {
        PolicyEvaluator.evaluatePolicies(subjectContext.getPolicies(), subjectContext, resourceContext, operationContext, true, false);
    }

    private static void evaluateAllowSubjectPolicies(SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext) {
        PolicyEvaluator.evaluatePolicies(subjectContext.getPolicies(), subjectContext, resourceContext, operationContext, false, false);
    }

    private static void evaluateDenyResourcePolicies(SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext) throws IOException {
        if (resourceContext == null || resourceContext.getOwner() == null) {
            return;
        }
        Iterator<SubjectContext.PolicyContext> resourcePolicies = subjectContext.getResourcePolicies(resourceContext.getOwner());
        PolicyEvaluator.evaluatePolicies(resourcePolicies, subjectContext, resourceContext, operationContext, true, true);
    }

    private static void evaluateAllowResourcePolicies(SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext) throws IOException {
        if (resourceContext == null || resourceContext.getOwner() == null) {
            return;
        }
        Iterator<SubjectContext.PolicyContext> resourcePolicies = subjectContext.getResourcePolicies(resourceContext.getOwner());
        PolicyEvaluator.evaluatePolicies(resourcePolicies, subjectContext, resourceContext, operationContext, false, true);
    }

    private static void evaluatePolicies(Iterator<SubjectContext.PolicyContext> policies, SubjectContext subjectContext, ResourceContextInterface resourceContext, OperationContext operationContext, boolean evaluateDeny, boolean evaluateResourcePolicies) {
        while (policies.hasNext() && !operationContext.getOperations().isEmpty()) {
            SubjectContext.PolicyContext context = policies.next();
            for (CompiledRule rule : context.getRules()) {
                if (evaluateResourcePolicies && !rule.isResourceBased()) continue;
                LOG.debug("evaluating policy for {} {}:{}:{}", new Object[]{evaluateDeny ? "deny" : "allow", context.getRoleName(), context.getPolicyName(), rule.getName()});
                if (evaluateDeny) {
                    rule.evaluateDenyRule(operationContext, subjectContext, resourceContext, context);
                    continue;
                }
                rule.evaluateAllowRule(operationContext, subjectContext, resourceContext, context);
            }
        }
    }

    public static List<ResourcePermission> listPermission(@NonNull SubjectContext subjectContext) {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        Map<String, ResourcePermission> resourcePermissionMap = PolicyEvaluator.initResourcePermissions();
        Iterator<SubjectContext.PolicyContext> policies = subjectContext.getPolicies();
        while (policies.hasNext()) {
            SubjectContext.PolicyContext policyContext = policies.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.setPermission(resourcePermissionMap, policyContext);
            }
        }
        return new ArrayList<ResourcePermission>(resourcePermissionMap.values());
    }

    public static List<ResourcePermission> listPermission(@NonNull List<EntityReference> policies) {
        if (policies == null) {
            throw new NullPointerException("policies is marked non-null but is null");
        }
        Map<String, ResourcePermission> resourcePermissionMap = PolicyEvaluator.initResourcePermissions();
        SubjectContext.PolicyIterator policyIterator = new SubjectContext.PolicyIterator("", "", null, policies);
        while (policyIterator.hasNext()) {
            SubjectContext.PolicyContext policyContext = policyIterator.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("Evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.setPermission(resourcePermissionMap, policyContext);
            }
        }
        return new ArrayList<ResourcePermission>(resourcePermissionMap.values());
    }

    public static ResourcePermission getPermission(@NonNull SubjectContext subjectContext, String resourceType) {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        ResourcePermission resourcePermission = PolicyEvaluator.getResourcePermission(resourceType, Permission.Access.NOT_ALLOW);
        Iterator<SubjectContext.PolicyContext> policies = subjectContext.getPolicies();
        while (policies.hasNext()) {
            SubjectContext.PolicyContext policyContext = policies.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.setPermission(resourceType, resourcePermission, policyContext);
            }
        }
        return resourcePermission;
    }

    public static ResourcePermission getPermission(@NonNull SubjectContext subjectContext, ResourceContextInterface resourceContext) {
        if (subjectContext == null) {
            throw new NullPointerException("subjectContext is marked non-null but is null");
        }
        ResourcePermission resourcePermission = PolicyEvaluator.getResourcePermission(resourceContext.getResource(), Permission.Access.NOT_ALLOW);
        Iterator<SubjectContext.PolicyContext> policies = subjectContext.getPolicies();
        while (policies.hasNext()) {
            SubjectContext.PolicyContext policyContext = policies.next();
            for (CompiledRule rule : policyContext.getRules()) {
                LOG.debug("evaluating {}:{}:{}\n", new Object[]{policyContext.getRoleName(), policyContext.getPolicyName(), rule.getName()});
                rule.setPermission(subjectContext, resourceContext, resourcePermission, policyContext);
            }
        }
        return resourcePermission;
    }

    public static List<ResourcePermission> getResourcePermissions(Permission.Access access) {
        ArrayList<ResourcePermission> resourcePermissions = new ArrayList<ResourcePermission>();
        for (ResourceDescriptor rd : ResourceRegistry.listResourceDescriptors()) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (MetadataOperation operation : rd.getOperations()) {
                permissions.add(new Permission().withOperation(operation).withAccess(access));
            }
            ResourcePermission resourcePermission = new ResourcePermission().withResource(rd.getName()).withPermissions(permissions);
            resourcePermissions.add(resourcePermission);
        }
        return resourcePermissions;
    }

    public static ResourcePermission getResourcePermission(String resource, Permission.Access access) {
        ResourceDescriptor rd = ResourceRegistry.getResourceDescriptor(resource);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (MetadataOperation operation : rd.getOperations()) {
            permissions.add(new Permission().withOperation(operation).withAccess(access));
        }
        return new ResourcePermission().withResource(rd.getName()).withPermissions(permissions);
    }

    public static Map<String, ResourcePermission> initResourcePermissions() {
        List<ResourcePermission> resourcePermissions = PolicyEvaluator.getResourcePermissions(Permission.Access.NOT_ALLOW);
        HashMap<String, ResourcePermission> resourcePermissionMap = new HashMap<String, ResourcePermission>();
        resourcePermissions.forEach(rp -> resourcePermissionMap.put(rp.getResource(), (ResourcePermission)rp));
        return resourcePermissionMap;
    }
}

