/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.security.client.Auth0SSOClientConfig;
import org.openmetadata.schema.security.client.AzureSSOClientConfig;
import org.openmetadata.schema.security.client.CustomOIDCSSOClientConfig;
import org.openmetadata.schema.security.client.GoogleSSOClientConfig;
import org.openmetadata.schema.security.client.OktaSSOClientConfig;
import org.openmetadata.service.util.JsonUtils;

public class AuthenticationMechanismBuilder {
    public static AuthenticationMechanism build(AuthenticationMechanism authMechanism) {
        if (authMechanism != null) {
            if (AuthenticationMechanism.AuthType.JWT.equals((Object)authMechanism.getAuthType())) {
                authMechanism.setConfig((Object)JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class));
            } else if (AuthenticationMechanism.AuthType.SSO.equals((Object)authMechanism.getAuthType())) {
                SSOAuthMechanism ssoAuth = JsonUtils.convertValue(authMechanism.getConfig(), SSOAuthMechanism.class);
                switch (ssoAuth.getSsoServiceType()) {
                    case GOOGLE: {
                        ssoAuth.setAuthConfig((Object)JsonUtils.convertValue(ssoAuth.getAuthConfig(), GoogleSSOClientConfig.class));
                        break;
                    }
                    case OKTA: {
                        ssoAuth.setAuthConfig((Object)JsonUtils.convertValue(ssoAuth.getAuthConfig(), OktaSSOClientConfig.class));
                        break;
                    }
                    case AUTH_0: {
                        ssoAuth.setAuthConfig((Object)JsonUtils.convertValue(ssoAuth.getAuthConfig(), Auth0SSOClientConfig.class));
                        break;
                    }
                    case CUSTOM_OIDC: {
                        ssoAuth.setAuthConfig((Object)JsonUtils.convertValue(ssoAuth.getAuthConfig(), CustomOIDCSSOClientConfig.class));
                        break;
                    }
                    case AZURE: {
                        ssoAuth.setAuthConfig((Object)JsonUtils.convertValue(ssoAuth.getAuthConfig(), AzureSSOClientConfig.class));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("SSO service type [%s] can not be parsed.", ssoAuth.getSsoServiceType()));
                    }
                }
                authMechanism.setConfig((Object)ssoAuth);
            }
        }
        return authMechanism;
    }
}

