/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.gchat;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.gchat.GChatMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GChatPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(GChatPublisher.class);
    private final Invocation.Builder target;
    private final Client client;

    public GChatPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub, dao);
        if (eventSub.getSubscriptionType() != CreateEventSubscription.SubscriptionType.G_CHAT_WEBHOOK) {
            throw new IllegalArgumentException("GChat Alert Invoked with Illegal Type and Settings.");
        }
        Webhook webhook = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), Webhook.class);
        String gChatWebhookURL = webhook.getEndpoint().toString();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)eventSub.getTimeout().intValue(), TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)eventSub.getReadTimeout().intValue(), TimeUnit.SECONDS);
        this.client = clientBuilder.build();
        this.target = this.client.target(gChatWebhookURL).request();
    }

    @Override
    protected void onStartDelegate() {
        LOG.info("GChat Webhook publisher started");
    }

    @Override
    protected void onShutdownDelegate() {
        if (null != this.client) {
            this.client.close();
        }
    }

    @Override
    protected void sendAlert(EventResource.EventList list) {
        for (ChangeEvent event : list.getData()) {
            long attemptTime = System.currentTimeMillis();
            try {
                GChatMessage gchatMessage = ChangeEventParser.buildGChatMessage(event);
                Response response = this.target.post(Entity.entity((Object)gchatMessage, (MediaType)MediaType.APPLICATION_JSON_TYPE));
                if (response.getStatus() >= 300 && response.getStatus() < 400) {
                    this.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                    continue;
                }
                if (response.getStatus() >= 400 && response.getStatus() < 600) {
                    this.setNextBackOff();
                    this.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                    Thread.sleep(this.currentBackoffTime);
                    continue;
                }
                if (response.getStatus() != 200) continue;
                this.setSuccessStatus(System.currentTimeMillis());
            }
            catch (Exception e) {
                LOG.error("Failed to publish event {} to gchat due to {} ", (Object)event, (Object)e.getMessage());
                throw new EventPublisherException(String.format("Failed to publish event %s to gchat due to %s ", event, e.getMessage()));
            }
        }
    }
}

