/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class DashboardRepository
extends EntityRepository<Dashboard> {
    private static final String DASHBOARD_UPDATE_FIELDS = "owner,tags,charts,extension,followers,dataModels";
    private static final String DASHBOARD_PATCH_FIELDS = "owner,tags,charts,extension,followers,dataModels";

    public DashboardRepository(CollectionDAO dao) {
        super("v1/dashboards/", "dashboard", Dashboard.class, dao.dashboardDAO(), dao, "owner,tags,charts,extension,followers,dataModels", "owner,tags,charts,extension,followers,dataModels");
    }

    @Override
    public void setFullyQualifiedName(Dashboard dashboard) {
        dashboard.setFullyQualifiedName(FullyQualifiedName.add(dashboard.getService().getName(), dashboard.getName()));
    }

    @Override
    public Dashboard setFields(Dashboard dashboard, EntityUtil.Fields fields) throws IOException {
        dashboard.setService(this.getContainer(dashboard.getId()));
        dashboard.setFollowers(fields.contains("followers") ? this.getFollowers(dashboard) : null);
        dashboard.setCharts(fields.contains("charts") ? this.getRelatedEntities(dashboard, "chart") : null);
        dashboard.setDataModels(fields.contains("dataModels") ? this.getRelatedEntities(dashboard, "dashboardDataModel") : null);
        return dashboard.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), dashboard.getId()) : null);
    }

    @Override
    public void restorePatchAttributes(Dashboard original, Dashboard updated) {
        updated.withId(original.getId()).withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService());
    }

    private void populateService(Dashboard dashboard) throws IOException {
        DashboardService service = (DashboardService)Entity.getEntity(dashboard.getService(), "", Include.NON_DELETED);
        dashboard.setService(service.getEntityReference());
        dashboard.setServiceType(service.getServiceType());
    }

    public void setService(Dashboard dashboard, EntityReference service) {
        if (service != null && dashboard != null) {
            this.addRelationship(service.getId(), dashboard.getId(), service.getType(), "dashboard", Relationship.CONTAINS);
            dashboard.setService(service);
        }
    }

    @Override
    public void prepare(Dashboard dashboard) throws IOException {
        this.populateService(dashboard);
        dashboard.setCharts(EntityUtil.getEntityReferences(dashboard.getCharts(), Include.NON_DELETED));
        dashboard.setDataModels(EntityUtil.getEntityReferences(dashboard.getDataModels(), Include.NON_DELETED));
    }

    @Override
    public void storeEntity(Dashboard dashboard, boolean update) throws JsonProcessingException {
        EntityReference service = dashboard.getService();
        List charts = dashboard.getCharts();
        List dataModels = dashboard.getDataModels();
        dashboard.withService(null).withCharts(null).withDataModels(null);
        this.store(dashboard, update);
        dashboard.withService(service).withCharts(charts).withDataModels(dataModels);
    }

    @Override
    public void storeRelationships(Dashboard dashboard) {
        this.setService(dashboard, dashboard.getService());
        if (dashboard.getCharts() != null) {
            for (EntityReference chart : dashboard.getCharts()) {
                this.addRelationship(dashboard.getId(), chart.getId(), "dashboard", "chart", Relationship.HAS);
            }
        }
        if (dashboard.getDataModels() != null) {
            for (EntityReference dataModel : dashboard.getDataModels()) {
                this.addRelationship(dashboard.getId(), dataModel.getId(), "dashboard", "dashboardDataModel", Relationship.HAS);
            }
        }
        this.storeOwner(dashboard, dashboard.getOwner());
        this.applyTags(dashboard);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Dashboard original, Dashboard updated, EntityRepository.Operation operation) {
        return new DashboardUpdater(original, updated, operation);
    }

    private List<EntityReference> getRelatedEntities(Dashboard dashboard, String entityType) throws IOException {
        if (dashboard == null) {
            return Collections.emptyList();
        }
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findTo(dashboard.getId(), "dashboard", Relationship.HAS, entityType);
        return EntityUtil.populateEntityReferences(ids, entityType);
    }

    public class DashboardUpdater
    extends EntityRepository.EntityUpdater {
        public DashboardUpdater(Dashboard original, Dashboard updated, EntityRepository.Operation operation) {
            super((EntityRepository)DashboardRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.update("chart", "charts", CommonUtil.listOrEmpty((List)((Dashboard)this.updated).getCharts()), CommonUtil.listOrEmpty((List)((Dashboard)this.original).getCharts()));
            this.update("dashboardDataModel", "dataModels", CommonUtil.listOrEmpty((List)((Dashboard)this.updated).getDataModels()), CommonUtil.listOrEmpty((List)((Dashboard)this.original).getDataModels()));
        }

        private void update(String entityType, String field, List<EntityReference> updEntities, List<EntityReference> oriEntities) throws JsonProcessingException {
            DashboardRepository.this.deleteFrom(((Dashboard)this.updated).getId(), "dashboard", Relationship.HAS, entityType);
            for (EntityReference entity : updEntities) {
                DashboardRepository.this.addRelationship(((Dashboard)this.updated).getId(), entity.getId(), "dashboard", entityType, Relationship.HAS);
            }
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange(field, oriEntities, updEntities, added, deleted, EntityUtil.entityReferenceMatch);
        }
    }
}

