/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;

public class WorkflowRepository
extends EntityRepository<Workflow> {
    private static final String UPDATE_FIELDS = "owner";
    private static final String PATCH_FIELDS = "owner";

    public WorkflowRepository(CollectionDAO dao) {
        super("/v1/automations/workflow", "workflow", Workflow.class, dao.workflowDAO(), dao, "owner", "owner");
    }

    @Override
    public Workflow setFields(Workflow entity, EntityUtil.Fields fields) throws IOException {
        return entity.withOwner(fields.contains("owner") ? this.getOwner(entity) : null);
    }

    @Override
    public void prepare(Workflow entity) throws IOException {
        if (entity.getRequest() == null) {
            throw new IllegalArgumentException("Request must not be empty");
        }
    }

    @Override
    public void storeEntity(Workflow entity, boolean update) throws IOException {
        EntityReference owner = entity.getOwner();
        OpenMetadataConnection openmetadataConnection = entity.getOpenMetadataServerConnection();
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        if (secretsManager != null) {
            entity = secretsManager.encryptOrDecryptWorkflow(entity, true);
        }
        entity.withOwner(null).withHref(null).withOpenMetadataServerConnection(null);
        this.store(entity, update);
        entity.withOwner(owner).withOpenMetadataServerConnection(openmetadataConnection);
    }

    @Override
    public void storeRelationships(Workflow entity) throws IOException {
        this.storeOwner(entity, entity.getOwner());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Workflow original, Workflow updated, EntityRepository.Operation operation) {
        return new WorkflowUpdater(original, updated, operation);
    }

    public class WorkflowUpdater
    extends EntityRepository.EntityUpdater {
        public WorkflowUpdater(Workflow original, Workflow updated, EntityRepository.Operation operation) {
            super((EntityRepository)WorkflowRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("status", ((Workflow)this.original).getStatus(), ((Workflow)this.updated).getStatus());
            this.recordChange("response", ((Workflow)this.original).getResponse(), ((Workflow)this.updated).getResponse(), true);
        }
    }
}

